/*
**
**  MBFIRE class 
**
**  (c) 1997, mike warren
**  mikeBot
**
**
**  SKELETON AI CLASS: see mbfire.cpp for documentation/suggested
**  improvements.
**
*/

#ifndef _MBFIRE_H_
#define _MBFIRE_H_

#include "mbotbase.h"
#include "mbtalk.h"

class mbfire : public mbtalk
{
protected:

  int mbf_oldTarget;

  vector mbf_predictedPosition;	// where i think the target will be

  int mbf_shoot;		// 2 if inactive, 1 or 0 if active
  int mbf_impulse;		// for weapon changes, etc. 0 is nothing

  vector mbf_facing;		// where firing system wants to aim

  int aimAt( int );		// adjusts facing to aim at the specified ent.

  void fire() { if( mbf_shoot == 2 ) mbf_shoot = 1; }

  void predictPosition( int );
  void selectWeapon();

public:
  
  mbfire();
  ~mbfire(){}

  void botShoot() { mbf_shoot=1; }
  void update();

  void forceShoot() { fire(); }

  void mbf_printTarget() { if( mbf_target != -1 ) printf("`%s'", players[mbf_target-1].name); else printf("`none'"); }
  void sendImpulse( int x ) { mbf_impulse=x; }

  int cmd( char *	);

};



#endif
