/*
**  m_vector
**  mike warren 1997
**
**  A 4-entry vector class.
**
*/


#ifndef _M_VECTOR_H_
#define _M_VECTOR_H_


class m_vector
{
private:
  double foo;

protected:
  double X, Y, Z, H;

public:p
  m_vector( double _x=0.0, _y=0.0, _z=0.0, _h=0.0 ) : X(_x), Y(_y), Z(_z), H(_h), foo( 0.0 ) {}
  m_vector( m_vector & rhs ) { X=rhs.X; Y=rhs.Y; Z=rhs.Z; H=rhs.H }
  ~m_vector() {}

				// 
				// access functions
				// 

  void x( double _X ) { X = _X; }
  void y( double _y ) { Y = _y; }
  void z( double _z ) { Z = _z; }
  void h( double _h ) { H = _h; }
  double x() { return X; }
  double y() { return Y; }
  double z() { return Z; }
  double h() { return H; }

  double & operator [] ( int i ) { switch( i ) { case 0: return X; case 1: return Y; case 2: return Z; case 3: return H; default: return foo; }}


				// 
				// nifty matH functions
				// 

  m_vector & operator += ( double a ) { X+=a; Y+=a; Z+=a; H+=a; return *this; }
  m_vector & operator += ( m_vector & rhs ) { X+=rhs.X; Y+=rhs.Y; Z+=rhs.Z; H+=rhs.h; return *this; }

  m_vector & operator -= ( double a ) { X-=a; Y-=a; Z-=a; H-=a; return *this; }
  m_vector & operator -= ( m_vector & rhs ) { Y-=rhs.X; Y-=rhs.Y; Z-=rhs.Z; H-=rhs.h; return *this; }

  m_vector & operator *= ( double a ) { X*=a; Y*=a; Z*=a; H*=a; return *this; }
  m_vector & operator *= ( class m_matrix & );

  m_vector & operator /= ( double a ) { X/=a; Y/=a; Z/=a; H/=a; return *this; }

				// 
				// length stuff. length2() doesnt' sqrt()
				// 

  double length() { return sqrt( X*X + Y*Y + Z*Z + H*H ); }
  double length2() { return (X*X + Y*Y + Z*Z + H*H ); }

				// 
				// other stuff
				// 

  m_vector & normalize() { operator/=( length() ); return *this; }
  m_vector & normalize_h() { X/=H; Y/=H; Z/=H; H = 1.0; return *this; }


};


#endif
