/*
**  m_string
**  mike warren 1997
**
**  simple string class
**
**  TODO:
**    . incorporate m_file input/output
**
*/



#ifndef _M_STRING_H_
#define _M_STRING_H_

const int M_STRING_SIZE = 1024;

#include <string.h>
#include <iostream.h>

class m_string
{
private:
  char m_pcStringdata[ M_STRING_SIZE ];

protected:

public:
  m_string( char * const s = 0 ) 
  { 
    if( s ) 
      strncpy( m_pcStringdata, s, M_STRING_SIZE ); 
    else 
      m_pcStringdata[0]=0;
  }
  m_string( m_string & rhs ) 
  { 
    strncpy( m_pcStringdata, rhs.m_pcStringdata, M_STRING_SIZE );
  }
  ~m_string() {}

  void operator = ( const char * rhs ) 
  { 
    strncpy( m_pcStringdata, rhs, M_STRING_SIZE );
  }


				// 
				// comparison operators
				// 

  int operator == ( m_string & rhs ) const 
  { 
    return strncmp( m_pcStringdata, rhs.m_pcStringdata, M_STRING_SIZE ) == 0;
  }
  int operator != ( m_string & rhs ) const { return !(operator==( rhs )); }

  int operator < ( m_string & rhs ) const 
  { 
    return strncmp( m_pcStringdata, rhs.m_pcStringdata, M_STRING_SIZE ) < 0; 
  }
  int operator > ( m_string & rhs ) const 
  { 
    return strncmp( m_pcStringdata, rhs.m_pcStringdata, M_STRING_SIZE ) > 0; 
  }
  int operator <= ( m_string & rhs ) const 
  { 
    return strncmp( m_pcStringdata, rhs.m_pcStringdata, M_STRING_SIZE ) <= 0; 
  }
  int operator >= ( m_string & rhs ) const 
  { 
    return strncmp( m_pcStringdata, rhs.m_pcStringdata, M_STRING_SIZE ) >= 0; 
  }

  int operator == ( char * const rhs ) const 
  { 
    return strncmp( m_pcStringdata, rhs, M_STRING_SIZE ) == 0;
  }
  int operator != ( char * const rhs ) const { return !(operator==( rhs )); }

  int operator < ( char * const rhs ) const 
  { 
    return strncmp( m_pcStringdata, rhs, M_STRING_SIZE ) < 0; 
  }
  int operator > ( char * const rhs ) const 
  { 
    return strncmp( m_pcStringdata, rhs, M_STRING_SIZE ) > 0;
  }
  int operator <= ( char * const rhs ) const 
  { 
    return strncmp( m_pcStringdata, rhs, M_STRING_SIZE ) <= 0;
  }
  int operator >= ( char * const rhs ) const 
  { 
    return strncmp( m_pcStringdata, rhs, M_STRING_SIZE ) >= 0;
  }

				// 
				// cast operator
				// 

  operator const char * () const { return m_pcStringdata; }
  operator char * () const { return (char *)m_pcStringdata; }

				// 
				// concatenation
				// 

  void operator += ( char * const rhs ) 
  { 
    strncat( m_pcStringdata, rhs, M_STRING_SIZE );
  }
  void operator += ( m_string & rhs )
  {
    strncat( m_pcStringdata, rhs.m_pcStringdata, M_STRING_SIZE );
  }

				// 
				// access/size methods
				// 

  char & operator [] ( int i ) const { return (char &)m_pcStringdata[ i%M_STRING_SIZE ];}
  int size() const { return M_STRING_SIZE; }
  int length() const { return strlen( m_pcStringdata ); }

				// 
				// input/output
				// 

  friend ostream & operator << ( ostream & os, m_string & rhs )
  { 
    for( int i=0; rhs.m_pcStringdata[ i ] && i < M_STRING_SIZE; i++ )
      os << rhs.m_pcStringdata[ i ]; 
    return os; 
  }

  friend istream & operator >> ( istream & is, m_string & rhs ) 
  { 
    for( int i=0; i < M_STRING_SIZE; i++ ) 
      { 
	is >> rhs.m_pcStringdata[i]; 
	if( rhs.m_pcStringdata[i]=='\n' || rhs.m_pcStringdata[i]=='\r' ) 
	  break; 
      } 
    return is; 
  }

};

#endif
