/*
**  m_polygon
**  mike warren 1997
**
**  simple polygon class
**
*/



#ifndef _M_POLYGON_H_
#define _M_POLYGON_H_

#define POLY_MAX_POINTS 16

#include "m_plane.h"
#include "vector.h"

class m_polygon
{
private:
	void expand()
	{
		vector ** n = new vector* [ m_dCapacity + POLY_MAX_POINTS ];
		for( int i=0; i < m_dNumPoints; i++ )
			n[ i ] = m_vPoints[ i ];

		delete [] m_vPoints;
		m_vPoints = n;
	}

protected:
	m_plane * m_pPlane;

	int m_bOnFront;
	int m_dPolygonNumber;

	vector ** m_vPoints;
	int m_dCapacity;
	int m_dNumPoints;

	m_polygon( m_polygon & );


public:
	m_polygon( int n = POLY_MAX_POINTS )
	{
		m_vPoints = new vector* [ n ]; 
		m_dCapacity = n;
		m_dNumPoints = 0;
		m_bOnFront = 0;
		m_dPolygonNumber = 0;
	}
	~m_polygon() { delete [] m_vPoints; }

	void addPoint( vector * p )
	{
		if( m_dNumPoints >= m_dCapacity-1 )
			expand();

		m_vPoints[ m_dNumPoints++ ] = p;
	}

	vector & operator [] ( int index ) const { return *m_vPoints[ index%m_dNumPoints ]; }

	void onFront( int x ) { m_bOnFront = x; }
	int onFront() const { return m_bOnFront; }

	vector normal() const { return m_bOnFront?m_pPlane->normal() : -m_pPlane->normal(); }

	m_plane * pPlane() const { return m_pPlane; }
	m_plane plane() const { return *m_pPlane; }
	void plane( m_plane * p ) { m_pPlane = p; }

	int isFloor();

	int pointInside( vector );	

	int number() const { return m_dPolygonNumber; }
	void number( int x ) { m_dPolygonNumber = x; }

	vector center();

};

#endif

