/*
**  m_polygon
**  mike warren 1997
**
**  
*/



#include "m_polygon.h"
#include <math.h>

/*
**  isFloor
**
**  Returns TRUE if this polygon is a floor polygon (i.e. on an upward-
**  facing plane)
**
*/

int m_polygon::isFloor()
{
	vector unitz( 0.0, 0.0, 1.0 );

	double dot = unitz * plane().normal();

	if( dot <= 0.0 && onFront() )
		return TRUE;

	if( dot >= 0.0 && !onFront() )
		return TRUE;

	return FALSE;

}

/*
**  pointInside
**
**  Returns TRUE if the point passed is inside the polygon. BE AWARE THAT
**  BOTH THE POINT AND THE POLYGON ARE PROJECTED TO THE z=0 PLANE FIRST.
**
**  ASSUMES the polygon is convex.
**
*/

int m_polygon::pointInside( vector p )
{
	if( m_dNumPoints < 3 )
		return FALSE;
	
	p.setz( (float)0.0 );
	double deltaAngle;
	double totalAngle = 0.0;
	vector lv, fv;

	fv = *m_vPoints[ m_dNumPoints-1 ];
	fv.setz( (float)0.0 );
	fv -= p;

	for( int i=0; i < m_dNumPoints; i++ )
	{
		lv = *m_vPoints[ i ];
		lv.setz( (float)0.0 );
		lv -= p;

		deltaAngle = ((fv * lv) / (fv.length() * lv.length()));
		totalAngle += acos( deltaAngle );
		fv = lv;
	}

	if( totalAngle > 6.28 && totalAngle < 6.29 )
		return TRUE;

	return FALSE;
}




/*
**  center
**
**  returns the center of the polygon. ASSUMES the polygon is convex.
**
*/

vector m_polygon::center()
{
	vector middle;

	for( int i=0; i < m_dNumPoints; i++ )
	{
		middle += *m_vPoints[ i ];
	}

	middle /= (float)m_dNumPoints;

	return middle;
}
