/*
**  m_list
**  mike warren 1997
**
*/


#ifndef _M_LIST_H_
#define _M_LIST_H_

template< class T > class m_listNode
{
public:
  T data;
  m_listNode<T> * next;
  m_listNode<T> * prev;

  m_listNode( m_listNode<T> * n=0, m_listNode<T> * p = 0 )
    {
      next = n; prev = p;
    }
  m_listNode( T d, m_listNode<T> * n=0, m_listNode<T> * p = 0 )
    {
      next = n; prev = p; data = d; 
    }
};



template< class T > class m_list
{
protected:
  m_listNode< T > * head;
  m_listNode< T > * tail;
  m_listNode< T > * current;

  void _deleteAllElements();

public:
  m_list() { head = tail = current= (m_listNode<T> *)0; }
  ~m_list() { _deleteAllElements(); }
  
  m_listNode< T > * find( T );
  int findAndDelete( T );

  void empty() { if( !isEmpty() )_deleteAllElements(); }

  void reset() { current = head; }
  int isEmpty() { return head==(m_listNode< T > *)0; }

  int operator ++ () { if( current ) current=current->next; return !(current==(m_listNode<T> *)0); }
  int operator -- () { if( current ) current=current->prev; return !(current==(m_listNode<T> *)0); }
  T operator * () { return current->data; }
  
  int addHead( T );
  int addTail( T );

  int deleteHead();
  int deleteTail();

};


#endif
  
