/*
**  m_list
**  mike warren 1997
**
*/


#include "m_list.h"
#include "vector.h"


template m_list< int >;
template m_list< class packFile * >;
template m_list< class m_polygon * >;
template m_list< class vector >;
template m_list< class m_BSPnode * >;


/*
**  _deleteAllElements
**
**  Does just that.
**
*/

template< class T >
void m_list< T >::_deleteAllElements()
{
  m_listNode< T > * q, * p = head;

  while( p )
    {
      q = p;
      p = p->next;
      delete q;
    }
  head = tail = current = (m_listNode< T > *) 0;
}


/*
**  find
**
**  Tries to find the selected data. Returns NULL on failure
**
*/

template< class T >
m_listNode< T > * m_list< T >::find( T target )
{
  m_listNode< T > * p = head;

  while( p )
    {
      if( p->data == target )
	  {
		  current = p;
		  return p;
	  }
      p = p->next;
    }

  return (m_listNode< T > *)0;
}


/*
**  findAndDelete
**
**  Same as above, but deletes the instance if it's found. Returns
**  1 on success, 0 on failure.
**
*/

template< class T >
int m_list< T >::findAndDelete( T target )
{
  m_listNode< T > * p = head, * q;

  while( p )
    {
      if( p->data == target )
	{
	  q = p;
	  if( p->prev ) p->prev->next = p->next;
	  if( p->next ) p->next->prev = p->prev;
	  if( current == q ) current = head;
	  delete q;
	  return 1;
	}
    }

  return 0;
}



/*
**  add*()
**
**  These functions both add at the specified position
**
*/

template< class T >
int m_list< T >::addHead( T item )
{
  if( !head )
    {
      head = new m_listNode< T >( item, 0, 0 );
      tail = head;
	  current = head;
      return 1;
    }

  m_listNode< T > * p = new m_listNode< T >( item, head, 0 );
  
  head = p;
  if( head->next )
    head->next->prev = p;


  return 1;
}

template< class T >
int m_list< T >::addTail( T item )
{
  if( !tail )
    {
      tail = new m_listNode< T >( item, 0, 0 );
      head = tail;
	  current=tail;
      return 1;
    }

  m_listNode< T > * p = new m_listNode< T >( item, 0, tail );

  tail = p;
  if( tail->prev )
    tail->prev->next = p;

  return 1;
}


/*
**  delete*()
**
**  Deletes the head or tail of the list
**
*/

template< class T >
int m_list< T >::deleteHead()
{
  if( !head ) return 0;

  m_listNode< T > * p = head;

  head = p->next;
  if( p->next ) p->next->prev = (m_listNode<T> *)0;
  else tail=head;
  delete p;
  if( current == p ) current = head;

  return 1;
}

template< class T >
int m_list< T >::deleteTail()
{
  if( !tail ) return 0;

  m_listNode< T > * p = tail;

  tail = p->prev;
  if( p->prev ) p->prev->next = (m_listNode<T> *)0;
  else head = tail;
  delete p;
  if( current == p ) current = tail;

  return 1;
}
