//
//  m_hash
//  mike warren 1997
//
//  Simple hash table. Depends on m_string
//
//


#ifndef _M_HASH_H_
#define _M_HASH_H_

#include <stdio.h>

const int M_HASH_TABLE_SIZE = 1024;
#include "m_string.h"

template< class T > class m_hash
{
private:
	T * m_atTable;
	m_string * m_asKeys;
	int m_dTableSize;
	int m_dNumNew;

protected:
	T m_tDefaultValue;
	m_string m_sTempString;

	int _getHashValue( m_string const & );
	void _expand();

public:
	m_hash();
	~m_hash() { delete [] m_atTable; delete [] m_asKeys; }

	T get( class m_string & );
	void set( class m_string const &, T );

	T get( const char * s ) { m_sTempString = s; return get( m_sTempString ); }
	void set( const char * s, T d ) { m_sTempString = s; set( m_sTempString, d ); }

	T defaultValue() { return m_tDefaultValue; }
	void defaultValue( T & x ) { m_tDefaultValue = x; }

	friend ostream & operator << ( ostream &, m_hash< T > & );
};








#endif