//
//  m_hash
//  mike warren 1997
//
//  simple hash table implementation 
//


#include "m_hash.h"
#include "m_string.h"

template m_hash< int >;
template m_hash< m_string >;

/*
**  ctor
**
*/

template< class T >
m_hash< T >::m_hash()
{ 
	m_atTable = new T[ M_HASH_TABLE_SIZE ]; 
	m_asKeys = new m_string[ M_HASH_TABLE_SIZE ];
	m_dTableSize = M_HASH_TABLE_SIZE;

	m_dNumNew = 0;
}


/*
**  _getHashValue
**
**  Returns a hash value for a m_string. The hash value is guarunteed to
**  be somewhere within the table[]
**
*/

template< class T >
int m_hash< T >::_getHashValue( m_string const & s )
{
	int hash=0;
	for( int i=0; i < s.size(); i++ )
	{
		hash += s[ i ];
		hash = hash << 2;
	}
	hash %= m_dTableSize;

	return hash;
}


/*
**  _expand
**
**  Grows the table by M_HASH_TABLE_SIZE elements.
**
*/

template< class T >
void m_hash< T >::_expand()
{
	T * newTable = new T[ m_dTableSize + M_HASH_TABLE_SIZE ];
	m_string * newKeys = new m_string[ m_dTableSize + M_HASH_TABLE_SIZE ];

	for( int i=0; i < m_dTableSize; i++ )
	{
		newTable[ i ] = m_atTable[ i ];
		newKeys[ i ] = m_asKeys[ i ];
	}

	delete [] m_atTable;
	m_atTable = newTable;
	m_dTableSize += M_HASH_TABLE_SIZE;
}


/*
**  get
**
**  Returns the data item associated with the m_string, or returns
**  m_hash::defaultValue().
**
*/

template< class T >
T m_hash< T >::get( m_string & s )
{
	int i = _getHashValue( s );

	for( int j=0; j < m_dTableSize; j++ )
	{
		if( m_asKeys[ i ] == s )
			return m_atTable[ i ];
		else if( m_asKeys[ i ].length() == 0 )
			return m_tDefaultValue;
		i++;
		i = i % m_dTableSize;
	} 

	return m_tDefaultValue;
}


/*
**  set
**
**  If the element is already in the table, changes its value, else adds
**  a new entry.
**
*/

template< class T >
void m_hash< T >::set( m_string const & s, T data )
{
	if( ++m_dNumNew > (M_HASH_TABLE_SIZE/2) )
	{
		_expand();
		m_dNumNew = 0;
	}

	int i = _getHashValue( s );

	for( int j=0; j < m_dTableSize; j++ )
	{
		if( m_asKeys[ i ] == s )
		{
			m_atTable[ i ] = data;
			return;
		}
		else if( m_asKeys[ i ].length() == 0 )
		{
			m_asKeys[ i ] = s;
			m_atTable[ i ] = data;
			return;
		}
		i++;
		i %= m_dTableSize;
	}
}