/*
**  MFILE class
**  (c) 1997 mike warren
**
**  encapsulates endianess convertion to/from files
**  compatible with .PAK file issues (i.e. minSize and maxSize)
**
**  this code is *not* freeware. See the file ``README'' or contact
**  mbwarren@acs.ucalgary.ca
**
**  TODO : allow writing ;)
**
*/

#ifndef _M_FILE_H_
#define _M_FILE_H_

#include <fcntl.h>
#include <stdio.h>

#if UNIX
#include <sys/types.h>
#include <unistd.h>
#endif

#if WIN32
#include <io.h>
#if !BORLAND
#define lseek _lseek
#define close _close
#define open _open
#endif
#endif

#define MF_BUFF_SIZE 4096
#define MF_THROW_EXCEPTIONS 1

class m_file
{
public:
  enum endianess_t { en_big, en_little, en_unknown };

private:
  endianess_t endianess;
  endianess_t determineEndianess();

protected:
  int fd;			// file descriptor
  int minSize;			// for playing with FD's in .PAK files
  int maxSize;			// (don't wanna read past the end of 'em)
  int readPos;			// reading next byte from here


				//
				// nCOD is for windows so I don't have to keep re-opening
				// the .PAK file. If TRUE, the file isn't closed in the
				// destructor
				//

  int noCloseOnDestruction;

  unsigned char t1[ 4 ];	// for byte swapping

  int bytesInBuff;		// max index into buff[]
  int bufferPointer;		// current index into buff[]
  unsigned char buff[ MF_BUFF_SIZE ];

  m_file(){}			// no NULL ctor

  int determineSize();		// figures out size of file (with lseek())
  int refillBuffer();		// gets more stuff from file
  void setAbsoluteReadPos( int x ) 
  { 
	  lseek( fd, x, SEEK_SET ); 
	  readPos=x; 
	  refillBuffer();
  }

public:
  m_file( char * fname, int min=0, int max=0 );
  m_file( int f, int min, int max ) 
  { 
	  fd=f;
	  minSize=min; 
	  maxSize=max;
	  bufferPointer=0; 
	  setAbsoluteReadPos( minSize ); 
	  noCloseOnDestruction=0; 
	  endianess = determineEndianess();
  }
  ~m_file() { if( !noCloseOnDestruction) close( fd ); }

  void NoCloseOnDestroy() { noCloseOnDestruction = 1; }
  void CloseOnDestroy() { noCloseOnDestruction = 0; }

  const int getSize() const { return maxSize-minSize; }
  const int getReadPos() const { return (readPos-minSize); }
  const int getAbsoluteReadPos() const { return readPos; }
  const int isEOF() const { return (readPos >= maxSize); }

  void setReadPos( int x );
	
				//
				//  these functions handle byte-swapping for loading
				//  different-endian data into big- or little- endian
				//  systems. readLE*() reads the data from the file
				//  assuming the data is Little Endian IN THE FILE. Little
				//  Endian order is used by Intel chips (PCs) with LSB first
				//

  int readLEint();
  int readBEint();
  short readLEshort();
  unsigned short readLEushort();
  unsigned short readBEushort();
  short readBEshort();
  float readLEfloat();
  float readBEfloat();

				//
				//  readChunk reads (int) number of bytes from the file
				//  and returns a brand-spanking NEW() pointer to it (so
				//  delete[] when you're through...
				//

  unsigned char * readChunk( int );
  unsigned char readByte(); 

  const int getFd() const { return fd; }

};


#endif





