/*
**  m_file
**  mike warren 1997
**
**  encapsulates endianess convertion to/from files
**
**  TODO : allow writing ;)
**
*/

#include "m_file.h"

/*
**  ctor
**
**  opens file (or throw()s exception)
**
*/

m_file::m_file( char * fname, int min, int max )
{
	noCloseOnDestruction = 0;

  endianess = determineEndianess();

#if !UNIX
  fd = open( fname, O_RDONLY|O_BINARY );
#else
  fd = open( fname, O_RDONLY );
#endif


 if( fd < 0 )
  {
#if !MF_THROW_EXCEPTIONS
    perror("m_file::m_file()");
    exit( -1 );
#else
    throw( "m_file::m_file(): file open error" );
#endif
  }

  if( max != min )
    {
      minSize=min; 
      maxSize=max;
    }
  else
    {
      minSize=0;
      maxSize = determineSize();
    }

  setAbsoluteReadPos( minSize );

}

/*
**  setReadPos 
**
**  sets position relative to beginning (minSize) of file
**
*/

void m_file::setReadPos( int x )
{ 
  if( x+minSize >= maxSize ) 
    {
      fprintf(stderr, "m_file::setReadPos(): %d beyond %d\n", x+minSize, maxSize);
      return; 
    }

  lseek( fd, (x+minSize), SEEK_SET ); 
  readPos=x+minSize; 
  refillBuffer(); 

}

/*
**  refillBuffer 
**
**  does just that (checks for EOF, etc, comaptable with .PAK)
**
*/

int m_file::refillBuffer()
{ 
  int b = MF_BUFF_SIZE;
  if( (maxSize - readPos) < MF_BUFF_SIZE )
    b = (maxSize-readPos);

  bufferPointer=0; 
  bytesInBuff = read( fd, (char *)buff, b ); 

  if( bytesInBuff < 0 ) 
    {
      perror("m_file::refillBuffer()");
      return 0;
    } 
  
  if( bytesInBuff==0 || b == 0 ) 		// EOF
    {
      printf("m_file::refillBuffer(): EOF\n");
      return 0;
    }

  return 1;

}


/*
**  readByte
**
**  returns the next byte from buffer[]...refills buffer if needed
**
*/

unsigned char m_file::readByte()
{
  if( bufferPointer < bytesInBuff )
    {
      readPos++;
      return buff[ bufferPointer++ ];
    }

  if( !refillBuffer() )
    {
      if( isEOF() )
	return 0;
#if !MF_THROW_EXCEPTIONS
      perror("m_file::readByte()");
      exit( -1 );
#else
      throw( "m_file::readByte(): file read error" );
#endif
    }
  
  readPos++;
  return buff[ bufferPointer++ ];
}

/*
**  determineSize
**
**  determines the size of the current file (MAKE SURE fd IS
**  VALID BEFORE CALLING THIS)
**                  
*/

int m_file::determineSize()
{
  int r;

  r = (int)lseek( fd, 0, SEEK_END );

  return r;
}
  

  


/*
**  readChunk
**
**  Reads a block of bytes
**
*/

unsigned char * m_file::readChunk( int n )
{
  unsigned char * p = new unsigned char[ n ];

  for( int i=0; i < n; i++ )
    if( (p[ i ] = readByte()) == 0 )
      if( isEOF() )
        break;

  return p;
}

/*
**  read{LE|BE}<type> functions return the number in the native machine's
**  endianess, assuming it is in {LE|BE} form in the file.
**
**  i.e. readLEint() returns an integer in this machines correct format on
**  the assumption it is in little-endian format in the file
**
*/

int m_file::readLEint()
{
if( endianess == en_big ) { 
  t1[3] = readByte();
  t1[2] = readByte();
  t1[1] = readByte();
  t1[0] = readByte();
} else {
  t1[0] = readByte();
  t1[1] = readByte();
  t1[2] = readByte();
  t1[3] = readByte();
}
  
  return *((int *)t1);
}

int m_file::readBEint()
{
if( endianess == en_big ) { 
  t1[0] = readByte();
  t1[1] = readByte();
  t1[2] = readByte();
  t1[3] = readByte();
} else {
  t1[3] = readByte();
  t1[2] = readByte();
  t1[1] = readByte();
  t1[0] = readByte();
}

  return *((int *)t1);
}

short m_file::readLEshort()
{
if( endianess == en_big ) { 
  t1[1] = readByte();
  t1[0] = readByte();
} else {
  t1[0] = readByte();
  t1[1] = readByte();
}

  return *(( short * ) t1 );
}

unsigned short m_file::readLEushort()
{
if( endianess == en_big ) { 
  t1[1] = readByte();
  t1[0] = readByte();
} else {
  t1[0] = readByte();
  t1[1] = readByte();
}

  return *((unsigned short * ) t1 );
}

short m_file::readBEshort()
{
if( endianess == en_big ) { 
  t1[0] = readByte();
  t1[1] = readByte();
} else {
  t1[1] = readByte();
  t1[0] = readByte();
}

  return *((short *)t1);
}

unsigned short m_file::readBEushort()
{
if( endianess == en_big ) { 
  t1[0] = readByte();
  t1[1] = readByte();
} else {
  t1[1] = readByte();
  t1[0] = readByte();
}

  return *((unsigned short *)t1);
}

float m_file::readLEfloat()
{
if( endianess == en_big ) { 
  t1[3] = readByte();
  t1[2] = readByte();
  t1[1] = readByte();
  t1[0] = readByte();
} else {
  t1[0] = readByte();
  t1[1] = readByte();
  t1[2] = readByte();
  t1[3] = readByte();
}

  return *((float *)t1);
}

float m_file::readBEfloat()
{
if( endianess == en_big ) { 
  t1[0] = readByte();
  t1[1] = readByte();
  t1[2] = readByte();
  t1[3] = readByte();
} else {
  t1[3] = readByte();
  t1[2] = readByte();
  t1[1] = readByte();
  t1[0] = readByte();
}
  
  return *((float *)t1);
}


/*
**  determineEndianess
**
**  Determines if system is little- or big- endian.
**
*/

m_file::endianess_t m_file::determineEndianess()
{
	short int number = 1;

	if( *((char *)&number) != (char)1 )
		return en_big;
	
	return en_little;
}