/*
**  graph class
**
**  (c) 1997 mike warren
**  mikeBot
**
**
**  Provides line of sight, leaf type, etc. Basically a nice interface
**  to the actual BSP tree. If you replace this with your own class,
**  you will need to supply all the same functions so the FIRE/NAV stuff
**  still works (or you could just make a derivitive class).
**
**
*/


#ifndef _GRAPH_H_
#define _GRAPH_H_

#include "defines.h"
#include "bsplevel.h"
#include "vector.h"
#include "m_stack.h"


class bspGraph
{
private:

  BSPlevel * map;			// the .BSP file, in a nice format
  m_BSPnode * currentNode;
  vector position;

  m_BSPnode * findLeaf( vector );

public:
  bspGraph() 
  { 
	  map=0;
	  currentNode = 0;
  }
  ~bspGraph() { delete map; }

  void updatePosition( vector & v ) 
  { 
	  position = v;
	  currentNode = findLeaf(v); 
  }

				//
				//  to do with leaves
				//

  m_BSPnode::type_t getCurrentLeafType();
  m_BSPnode::type_t getLeafType( vector );
  vector getLeafOrigin( int );

				//
				//  some BSP tracing functions
				//
  
  int isShotBlocked( vector, vector * h=0 );
  int isLineBlocked( vector start, vector end, vector * hp=0 );
  int isLineBlockedFluid( vector start, vector end, vector * hp=0, int water=FALSE );
  int modelBlocksLine( vector, vector, int ); 

				//
				//  misc.
				//
  
  int isLoaded() { return (map!=0); }
  int newMap( char * fname, int noGraph=0 );

 
};

#endif
  

