/*
**  support class for bspFile
**  (c) 1997 mike warren
**
**  this code is *not* freeware. See the file ``README'' or contact
**  mbwarren@acs.ucalgary.ca
**
**  (excuse the rather long ::read() inlined functions, but i didn't feel like
**   having lotsa .cc files :) )
**
*/




#ifndef _FACES_H_
#define _FACES_H_

#include "defines.h"
#include "mfile.h"

class bspFace
{
  unsigned short planeId;
  unsigned short side;		// 0 == on front of plane, 1==back
  int edgeListId;
  unsigned short edgeListNum; 
  unsigned short textureIndex;	// unused by me
  
  int lights;			// should be 4 char's, but i don't use it...

  int lightMap;			// index into lightmap
  
  bspFace(){}
  
public:
  
  bspFace( mFile & mf ) { read( mf ); }

  void read( mFile & mf ) { planeId=mf.readLEushort(); side=mf.readLEushort(); edgeListId=mf.readLEint(); edgeListNum=mf.readLEushort(); textureIndex=mf.readLEushort(); lights=mf.readLEint(); lightMap=mf.readLEint(); }

  int getPlaneId() { return (int)planeId; }
  int isOnFront() { return !side; }
  int getEdgeListId() { return edgeListId; }
  int getEdgeListNum() { return (int)edgeListNum; }
  int getTextureIndex() { return (int)textureIndex; }
  int getLightMap() { return lightMap; }

  void dump() { printf("%d %c %d %d\n", planeId, (side?'B':'F'), edgeListId, edgeListNum); }

};



class bspFaces
{
  bspFace ** faces;
  int loadedFaces;

  bspFaces(){}

public:
  
  bspFaces( mFile & mf, int n )
  {
	  faces=new bspFace* [ n ]; 
	  for( int i=0; i < n; i++)
		  faces[i]=0;
	  loadedFaces=0;
	  read( mf, n ); 
  }
  ~bspFaces() { for( int i=0; i < loadedFaces; i++ ) delete faces[i]; delete faces; }

  void read( mFile & mf, int n )
  {
	  for( int i=0; i < n; i++ )
		  faces[i] = new bspFace( mf );
	  loadedFaces=n; 
  }

  bspFace * getFace( int x ) { return operator[]( x ); }
  bspFace * operator[]( int x )
  {
	  if( x >= 0 && x < loadedFaces ) 
		  return faces[x];
	  else
		  return 0; 
  }
  int getNum() { return loadedFaces; }

  void dump() { for( int i=0; i < loadedFaces; i++) faces[i]->dump(); }

};


#endif

