/*
**  support class for bspFile
**  (c) 1997 mike warren
**
**  this code is *not* freeware. See the file ``README'' or contact
**  mbwarren@acs.ucalgary.ca
**
**  (excuse the rather long ::read() inlined functions, but i didn't feel like
**   having lotsa .cc files :) )
**
*/



#ifndef _EDGES_H_
#define _EDGES_H_

#include "defines.h"
#include "mfile.h"

class bspEdge
{
  unsigned short vertex[ 2 ];
  
  bspEdge(){}

public:
  bspEdge( mFile & mf ) { read( mf ); }
  ~bspEdge(){}

  void read( mFile & mf ) 
  { 
	  vertex[0] = mf.readLEushort();
	  vertex[1]=mf.readLEushort(); 
  }

  int getVertex( int x ) { return operator[]( x ); }
  int operator[] ( int x )
  { 
	  if( !(x==0 || x==1) ) 
		  return 0; 
	  return (int)vertex[x];
  }

  void dump() { printf("%d - %d\n", vertex[0], vertex[1] ); }

};


class bspEdges
{
  bspEdge ** edges;
  int loadedEdges;

  bspEdges(){}

public:
  bspEdges( mFile & mf, int n ) { edges = new bspEdge*[ n ]; for( int i=0; i < n; i++) edges[i] = 0; loadedEdges=0; read( mf, n ); }

  void read( mFile & mf, int n ) { for( int i=0; i < n; i++ ) edges[i]=new bspEdge( mf ); loadedEdges=n; }

  int getNum() { return loadedEdges; }
  bspEdge * getEdge( int x ) { if ( x>=0 && x < loadedEdges ) return edges[x]; return 0; }

  void dump() { for( int i=0; i < loadedEdges; i++ ) edges[i]->dump(); }

};


#endif
