/*
**  support class for bspFile
**  (c) 1997 mike warren
**
**  this code is *not* freeware. See the file ``README'' or contact
**  mbwarren@acs.ucalgary.ca
**
**  (excuse the rather long ::read() inlined functions, but i didn't feel like
**   having lotsa .cc files :) )
**
*/



#ifndef _CLIPNODE_H_
#define _CLIPBODE_H_

#include "defines.h"
#include "vector.h"


class bspClipnode
{
  int planeId;
  short front;
  short back;

  bspClipnode(){}

public:

  bspClipnode( mFile & mf ) { read( mf ); }

  void read( mFile & mf ) 
  { 
	  planeId=mf.readLEint(); 
	  front=mf.readLEshort(); 
	  back=mf.readLEshort(); 
  }

  int getPlaneId() { return planeId; }
  int getFront() { return front; }
  int getBack() { return back; }

  void dump() { printf("%d %d %d\n", planeId, front, back); }

};


class bspClipnodes
{
  bspClipnode ** clipnodes;
  int loadedClipnodes;

  bspClipnodes(){}

public:
  
  bspClipnodes( mFile & mf, int n ) 
  {
	  clipnodes=new bspClipnode* [ n ]; 
	  for(int i=0; i < n; i++) 
		  clipnodes[i]=0; 
	  loadedClipnodes=0; 
	  read( mf, n ); 
  }
  ~bspClipnodes()
  { 
	  for( int i=0; i < loadedClipnodes; i++)
		  delete clipnodes[i]; 
	  delete clipnodes;
  }

  void read( mFile & mf, int n ) { for( int i=0; i < n; i++) clipnodes[i] = new bspClipnode( mf ); loadedClipnodes=n; }
  
  bspClipnode * getClipnode( int x ) { return operator[]( x ); }
  bspClipnode * operator[] ( int x )
  { 
	  if ( x >= 0 && x < loadedClipnodes )
		  return clipnodes[x]; 
	  else
		  return 0;
  }
  int getNum() { return loadedClipnodes; }

  void dump() 
  { 
	  for( int i=0; i < loadedClipnodes; i++)
		  clipnodes[i]->dump(); 
  }

};


    
#endif
