/*
**  bspLevel
**  mike warren 1997
**
**  A "nice" BSP-object (i.e. more intuitive than bspFile)
**
*/


#ifndef _BSPLEVEL_H_
#define _BSPLEVEL_H_

#include "m_plane.h"
#include "m_polygon.h"
#include "m_line.h"
#include "bsp.h"
#include "vector.h"
#include <stdio.h>
#include "mfile.h"


class BSPlevel
{
protected:
	m_plane * m_aPlanes;
	m_polygon * m_aPolygons;
	m_line * m_edges;
	vector * m_vertices;

	m_BSPnode * m_pTreeRoot;
	m_BSPnode ** m_apModelRoots;

	m_BSPnode ** m_pBSPnodes;
	int m_dLeafOffset;
	int m_dNumLeaves;
	int numberOfLeavesAndNodes;

	int m_dNumPlanes;
	int m_dNumModels;
	int m_dNumPolygons;

	BSPlevel( BSPlevel & ){}

public:
	BSPlevel( mFile & );
	~BSPlevel();

	m_BSPnode * model( int i ) { if( i < m_dNumModels ) return 0; return m_apModelRoots[ i ]; }
	m_plane * pPlane( int i ) { return &(m_aPlanes[ i%m_dNumPlanes ]); }
	m_plane plane( int i ) { return m_aPlanes[ i%m_dNumPlanes ]; }

	m_polygon & polygon( int i ) { return m_aPolygons[ i%m_dNumPolygons ]; }

	m_BSPnode * worldspawnRoot() { return m_apModelRoots[ 0 ]; }

	int numLeaves() const { return m_dNumLeaves; }
	int numModels() const { return m_dNumModels; }
	int numPolygons() const { return m_dNumPolygons; }

	void printInfo()
	{
		printf("bspLevel: %d polygons, %d planes, %d models\n", m_dNumPolygons, m_dNumPlanes, m_dNumModels );
	}

};

#endif

	
