/*
**  bspFile class
**  (c) 1997 mike warren
**
**  this code is *not* freeware; please see the file ``README'' or 
**  contact mbwarren@acs.ucalgary.ca
**
**  reads .BSP files into bspFile objects
**
*/



#include "bspfile.h"
#include "mfile.h"

/*
**  ctor
**
**  loads everything (if possible) from specified file.
**
*/

bspFile::bspFile( char * fname )
{
  mFile * mf;

  try
  {
      mf = new mFile( fname );
  }
  catch( char * err )
  {
      fprintf(stderr, err);
#if QTHROW
     throw ( "bspFile::bspFile(): couldn't load file\n" );
#else
      printf("bspFile::bspFile(): couldn't load `%s'\n", fname);
      exit( -1 );
#endif
  }

  head = new bspHead( *mf );

  if( !(head->getVersion() == 29 || head->getVersion()==28) )
  {
#if QTHROW
      throw( "bspFile::bspFile(): .BSP version not 29 or 28\n" );
#else
      fprintf(stderr, "bspFile::bspFile(): version %d, not 29/28\n", head->getVersion() );
      exit( -1 );
#endif
  }

  bspEntry bent;

  bent = head->getEntry(BSPD_ENTITIES);
  mf->setReadPos( bent.getOffset() );
  entities = new bspEntities( *mf, bent.getSize()/BSP_ENTITY_SIZE );

  bent = head->getEntry(BSPD_PLANES);
  mf->setReadPos( bent.getOffset() );
  planes = new bspPlanes( *mf, bent.getSize()/BSP_PLANE_SIZE);

  bent = head->getEntry(BSPD_VERTICES);
  mf->setReadPos( bent.getOffset() );
  vertices = new bspVertices( *mf, bent.getSize()/BSP_VERTEX_SIZE);
  bent = head->getEntry(BSPD_NODES);
  mf->setReadPos( bent.getOffset() );
  nodes = new bspNodes( *mf, bent.getSize()/BSP_NODE_SIZE);

  bent = head->getEntry(BSPD_FACES);
  mf->setReadPos( bent.getOffset() );
  faces = new bspFaces( *mf, bent.getSize()/BSP_FACE_SIZE);

  bent = head->getEntry(BSPD_CLIPNODES);
  mf->setReadPos( bent.getOffset() );
  clipnodes = new bspClipnodes( *mf, bent.getSize()/BSP_CLIPNODE_SIZE);

  bent = head->getEntry(BSPD_LEAVES);
  mf->setReadPos( bent.getOffset() );
  leaves = new bspLeaves( *mf, bent.getSize()/BSP_LEAF_SIZE);

  bent = head->getEntry(BSPD_FACELIST);
  mf->setReadPos( bent.getOffset() );
  facelist = new bspFaceList( *mf, bent.getSize()/BSP_FACELIST_SIZE);

  bent = head->getEntry(BSPD_EDGES);
  mf->setReadPos( bent.getOffset() );
  edges = new bspEdges( *mf, bent.getSize()/BSP_EDGE_SIZE);

  bent = head->getEntry(BSPD_EDGELIST);
  mf->setReadPos( bent.getOffset() );
  edgelist = new bspEdgeList( *mf, bent.getSize()/BSP_EDGELIST_SIZE);

  bent = head->getEntry(BSPD_MODELS);
  mf->setReadPos( bent.getOffset() );
  models = new bspModels( *mf, bent.getSize()/BSP_MODEL_SIZE);

  delete mf;

}

/*
**  ctor : loads everything (if possible) from specified (open) file. 
**         DOES NOT CLOSE FILE
**
*/

bspFile::bspFile( mFile * mf )
{

  head = new bspHead( *mf );

  if( !(head->getVersion() == 29 || head->getVersion()==28) )
  {
#if QTHROW
      throw( "bspFile::bspFile(): .BSP version not 29 or 28\n" );
#else
      fprintf(stderr, "bspFile::bspFile(): version %d, not 29/28\n", head->getVersion() );
      exit( -1 );
#endif
  }

  bspEntry bent;

  bent = head->getEntry(BSPD_ENTITIES);
  mf->setReadPos( bent.getOffset() );
  entities = new bspEntities( *mf, bent.getSize()/BSP_ENTITY_SIZE );

  bent = head->getEntry(BSPD_PLANES);
  mf->setReadPos( bent.getOffset() );
  planes = new bspPlanes( *mf, bent.getSize()/BSP_PLANE_SIZE);

  bent = head->getEntry(BSPD_VERTICES);
  mf->setReadPos( bent.getOffset() );
  vertices = new bspVertices( *mf, bent.getSize()/BSP_VERTEX_SIZE);

  bent = head->getEntry(BSPD_NODES);
  mf->setReadPos( bent.getOffset() );
  nodes = new bspNodes( *mf, bent.getSize()/BSP_NODE_SIZE);

  bent = head->getEntry(BSPD_FACES);
  mf->setReadPos( bent.getOffset() );
  faces = new bspFaces( *mf, bent.getSize()/BSP_FACE_SIZE);

  bent = head->getEntry(BSPD_CLIPNODES);
  mf->setReadPos( bent.getOffset() );
  clipnodes = new bspClipnodes( *mf, bent.getSize()/BSP_CLIPNODE_SIZE);

  bent = head->getEntry(BSPD_LEAVES);
  mf->setReadPos( bent.getOffset() );
  leaves = new bspLeaves( *mf, bent.getSize()/BSP_LEAF_SIZE);

  bent = head->getEntry(BSPD_FACELIST);
  mf->setReadPos( bent.getOffset() );
  facelist = new bspFaceList( *mf, bent.getSize()/BSP_FACELIST_SIZE);

  bent = head->getEntry(BSPD_EDGES);
  mf->setReadPos( bent.getOffset() );
  edges = new bspEdges( *mf, bent.getSize()/BSP_EDGE_SIZE);

  bent = head->getEntry(BSPD_EDGELIST);
  mf->setReadPos( bent.getOffset() );
  edgelist = new bspEdgeList( *mf, bent.getSize()/BSP_EDGELIST_SIZE);

  bent = head->getEntry(BSPD_MODELS);
  mf->setReadPos( bent.getOffset() );
  models = new bspModels( *mf, bent.getSize()/BSP_MODEL_SIZE);

}

/*
**  printInfo : displays the number of each entry loaded
**
*/

void bspFile::printInfo()
{
  printf("%d entities\n", entities->getNum() );
  printf("%d planes\n", planes->getNum() );
  printf("%d vertices\n", vertices->getNum() );
  printf("%d nodes\n", nodes->getNum() );
  printf("%d faces\n", faces->getNum() );
  printf("%d clipnodes\n", clipnodes->getNum() );
  printf("%d leaves\n", leaves->getNum() );
  printf("%d facelists\n", facelist->getNum() );
  printf("%d edges\n", edges->getNum() );
  printf("%d edgelists\n", edgelist->getNum() );
  printf("%d models\n", models->getNum() );
}

/*
**  dump : calls dump for each entry
**
*/

void bspFile::dump()
{
  printf("entities\n");
  entities->dump();
  printf("planes\n");
  planes->dump();
  printf("vertices\n");
  vertices->dump();
  printf("nodes\n");
  nodes->dump();
  printf("faces\n");
  faces->dump();
  printf("clipnodes\n");
  clipnodes->dump();
  printf("leaves\n");
  leaves->dump();
  printf("facelist\n");
  facelist->dump();
  printf("edges\n");
  edges->dump();
  printf("edgelist\n");
  edgelist->dump();
  printf("models\n");
  models->dump();
}

