/*
**  BSP support routines and misc. classes
**  mike warren 1997
**
*/


#ifndef _BSP_MISC_H_
#define _BSP_MISC_H_

#include "mfile.h"

class BSPentry
{
private:
	int m_offset;
	int m_size;

public:
	BSPentry() { m_offset=0; m_size=0; }
	BSPentry( mFile & mf ) { m_offset = mf.readLEint(); m_size = mf.readLEint(); }
	~BSPentry(){}

	int size() const { return m_size; }
	int offset() const { return m_offset; }
};

class BSPhead
{
public:
	enum index_t { entities=0, planes, textures, vertices, visilist, nodes, texinfo, faces, lightmaps, clipnodes, leaves, facelist, edges, edgelist, models };

private:
	int m_version;
	BSPentry * entries[ 15 ];

public:
	BSPhead( mFile & mf )
	{
		m_version = mf.readLEint();
		for( int i=0; i < 15; i++ )
			entries[ i ] = new BSPentry( mf );
	}
	~BSPhead() { for( int i=0; i < 15; i++ ) delete entries[ i ]; }

	int version() const { return m_version; }
	BSPentry const & get( index_t i ) const { return *entries[ (int)i ]; }

};


#endif