/*
**  bspNode
**  mike warren 1997
**
**  A node of a BSP tree. 
**
*/


#ifndef _BSPNODE_H_
#define _BSPNODE_H_

#include "vector.h"
#include "nodes.h"
#include "m_list.h"
#include "m_polygon.h"
#include "m_plane.h"


class m_BSPnode
{
public:
	enum type_t { normal, solid, water, slime, lava, sky, unknown };

private:
	int m_isLeaf;
	type_t m_type;

protected:
	vector m_bboxMin;
	vector m_bboxMax;

	m_plane * m_pPlane;

	int m_faceID;
	int m_faceNumber;

	m_BSPnode * m_front;
	m_BSPnode * m_back;

	m_list< m_polygon * > m_polygons;

	m_BSPnode( bspNode & );

public:
	m_BSPnode() { m_front = 0; m_back = 0; m_pPlane=0; }
	~m_BSPnode(){}

	m_BSPnode * front() const { return m_front; }
	m_BSPnode * back() const { return m_back; }
	void front( m_BSPnode * x ) { m_front = x; }
	void back( m_BSPnode * x ) { m_back = x; }

	void addPolygon( m_polygon * x ) { m_polygons.addHead( x ); }

	vector & bboxMin() { return m_bboxMin; }
	vector & bboxMax() { return m_bboxMax; }
	void bboxMin( vector x ) { m_bboxMin = x; }
	void bboxMax( vector x ) { m_bboxMax = x; }

	m_polygon * floorPolygonForPoint( vector & );

	int isLeaf() const { return m_isLeaf; }
	void isLeaf( int x ) { m_isLeaf = x; }
	int isFrontLeaf() const
	{
		if( !m_front )
			return FALSE;
		return m_front->isLeaf();
	}

	int isBackLeaf() const
	{
		if( !m_back )
			return FALSE;
		return m_back->isLeaf();
	}

	m_plane & plane() { return *m_pPlane; }
	void plane( m_plane * x ) { m_pPlane = x; }

	type_t type() const { return m_type; }
	void type( type_t x ) { m_type = x; }
};



#endif