/*
**  m_BSPnode
**  mike warren 1997
**
**  A node of a BSP tree. 
**
*/


#include "bsp.h"


/*
**  floorPolygonForPoint
**
**  Determines which floor polygon for this leaf should be used
**  as "the" floor polygon, based on a posion. The polygon and the
**  point are projected onto the z=0 plane and point-in-polygon
**  operations are performed for each polygon.
**
**  Returns NULL if there is no suitable polygon (THIS SHOULD NEVER
**  HAPPEN IN MY APPLICATION OF IT)
**
**  TODO:
**    take out debug code (unless it's causing problems)
**
*/

m_polygon * m_BSPnode::floorPolygonForPoint( vector & point )
{
	if( !isLeaf() )
	{
		fprintf( debugFile, "m_BSPnode::floorPolygonForPoint(): I'm not a leaf\n");
		return (m_polygon *)0;
	}

	if( m_polygons.isEmpty() )
		return (m_polygon *)0;

	m_polygon * poly;
	m_polygon * r = 0;

	m_polygons.reset();

	int duplicates=0;

	do {
		poly = *m_polygons;

		if( poly->isFloor() )
			continue;

		if( poly->pointInside( point ) )
		{
			if( r )
			{
				duplicates++;
				fprintf( debugFile, "m_BSPnode::floorPolygonForPoint(): Duplicate suitable floor polygons found (%d)\n", duplicates );
			}
			r = poly;
		}
	} while( (++m_polygons) );

	return r;
}
