/*
**  mpack
**  mike warren 1997
**
**  Implementation of .PAK reading stuff. NOTE THAT in this implementation
**  only ONE FILE AT A TIME in the .PAK can be opened (under windows) 'cause
**  I can't coax win95 to duplicate file descriptors 
**
**  Self: look into this! (can this be done?)
**
**  mFile is useful; look at it :)
**
*/




#include "mpack.h"
#include "defines.h"
#include <string.h>

#if WIN32
#include <io.h>
#endif



/*
**  ctor
**
**  loads directory, etc. 
**
**  THROWS char * error
*/

packFile::packFile( char * pakname )
{
  mFile * mf;

  try 
  {
      mf = new mFile( pakname );
  } 
  catch( char * err ) 
  {
      printf( err );
      throw err;
  }

  mf->NoCloseOnDestroy();
  mf->setReadPos( 0 );
  ph = new packHeader( *mf );

  mf->setReadPos( ph->getOffset() );

  numDirEntries = ph->getSize()/64;

  entries = new packEntry*[ numDirEntries ];

#if 0
  printf("size: %d  offset: %d entries: %d\n", ph->getSize(), ph->getOffset(), numDirEntries );
#endif

  
  for( int i=0; i < numDirEntries; i++ )
  {
	  entries[i] = new packEntry( *mf );
#if 0
	  printf("entry %03d: `%-25s' offset: %d  size: %d\n", i, entries[i]->getFilename(), entries[i]->getOffset(), entries[i]->getSize() );
#endif
  }

#if WIN32
  fd = mf->getFd();		// FIXME -- can't; windows wont duplicate FD's
#else
  fd = fcntl( mf->getFd(), F_DUPFD );
#endif

  delete mf;

  if( fd < 0 )
  {
#if QTHROW
      throw( "packFile::packFile(): couldn't duplicate file descriptor\n" );
#else
      perror("packFile::packFile(): fcntl()");
      exit(-1);
#endif
  }

}
  

/*
**  getFile 
**
**  returns a (new) mFile object pointing to a section of .PAK
**  or NULL if not found. (wildcards NOT allowed)
**
*/

mFile * packFile::getFile( char * name )
{
  int i;
  int found=0;

/*
  for( i=0; i < (int)strlen( name ); i++ )
    if( name[i] == '/' )
      name[i] = '\\';
*/

  for( i=0; i < numDirEntries; i++ )
    if( !strncmp( entries[i]->getFilename(), name, 50 ) )
      {
#if 0
	    printf("`%s' at entry %d\n", name, i );
#endif
		found=1;
		break;
      }
  
  if( !found )
    return (mFile *)0;

#if !WIN32
  int fd1 = fcntl( fd, F_DUPFD );
  if( fd1 < 0 )
    {
      perror("packFile::getFile(): fcntl()");
      return (mFile *)0;
    }

  mFile * r = new mFile( fd1, entries[i]->getOffset(), entries[i]->getOffset()+entries[i]->getSize() );
#else
  if( _lseek( fd, entries[i]->getOffset(), SEEK_SET ) < 0L )
	  perror("packFile::getFile(): _lseek()");

#if 0
  printf("file descriptor %d\n", fd );
#endif

  mFile * r = new mFile( fd, entries[i]->getOffset(), entries[i]->getOffset()+entries[i]->getSize() );
  r->NoCloseOnDestroy();
#endif

  return r;
}


/*
**  dumpDirectoty : prints all files in pack
**
*/

void packFile::dumpDirectory()
{
  for( int i=0; i < numDirEntries; i++ )
    printf("%-50s : %d %d\n", entries[i]->getFilename(), entries[i]->getOffset(), entries[i]->getSize() );
}

/*
**  packList::addPack
**
**  Adds a packFile to a packFile list. Return TRUE on success, FALSE on
**  failure.
**
*/

int packList::addPack( char * fname )
{
	packFile * pf;

	try
	{
		pf = new packFile( fname );
	}
	catch( char * err )
	{
		fprintf( stderr, "packList::addPack(): %s\n", err );
		return FALSE;
	}

	printf("packList::addPack(): Added `%s' with %d files\n", fname, pf->getNum() );
	
	m_filelist.addTail( pf );
	return TRUE;
}
      
    
