/*
**  MFILE class
**
**  (c) 1997 mike warren
**  encapsulates endianess convertion to/from files
**  compatible with .PAK file issues (i.e. minSize and maxSize)
**
**  this code is *not* freeware. See the file ``README'' or contact
**  mbwarren@acs.ucalgary.ca
**
**  TODO : allow writing ;)
**
*/

#ifndef _MFILE_H_
#define _MFILE_H_

#include "defines.h"
#include <fcntl.h>
#include <stdio.h>

#if UNIX
#include <sys/types.h>
#include <unistd.h>
#endif

#if WIN32
#include <io.h>
 #if !BORLAND				/// thanks to Colin Skow (cskow@olympus.net)
  #define lseek _lseek
  #define close _close
  #define open _open
 #endif
#endif

#define MF_BUFF_SIZE 4096

class mFile
{
  int fd;			// file descriptor
  int minSize;			// for playing with FD's in .PAK files
  int maxSize;			// (don't wanna read past the end of 'em)
  int readPos;			// reading next byte from here

  unsigned char t1[ 4 ];	// for byte swapping

  int bytesInBuff;		// max index into buff[]
  int bufferPointer;		// current index into buff[]
  unsigned char buff[ MF_BUFF_SIZE ];

  mFile(){}			// no NULL ctor

  int determineSize( );
  int refillBuffer(); 
  void setAbsoluteReadPos( int x ) { lseek( fd, x, SEEK_SET ); readPos=x; refillBuffer(); }

public:
  mFile( char * fname, int min=0, int max=0 );
  mFile( int f, int min, int max ) { fd=f; minSize=min; maxSize=max; bufferPointer=0; setAbsoluteReadPos( minSize ); }
  ~mFile() { close( fd ); }

  int getSize() { return maxSize-minSize; }
  int getReadPos() { return (readPos-minSize); }
  int getAbsoluteReadPos() { return readPos; }
  int isEOF() { return (readPos >= maxSize); }

  void setReadPos( int x );

  int readLEint();
  int readBEint();
  short readLEshort();
  unsigned short readLEushort();
  unsigned short readBEushort();
  short readBEshort();
  float readLEfloat();
  float readBEfloat();
  unsigned char * readChunk( int );
  unsigned char readByte(); 

  int getFd() { return fd; }

};


#endif





