/*
**
**  MBOT class
**
**  (c) 1997 mike warren
**  mikeBot
**
**
**  handles some bot functions; most are in MBFIRE and MBNAV (well, its
**  derived from them afterall)
**
*/


#include "defines.h"
#include "mbot.h"
#include <math.h>

/*
**  ctor
**
*/

mbot::mbot()
{
  respawn=0;
}

/*
**  update : calls mbfire update, then mbnav update(), then messes with the
**	     idealSpeeds from mbnav and the facing from mbfire, and sends
**	     a movement packet. (first calls qcs::update() )
**
*/

void mbot::update()
{

  map.updatePosition( entities[myEntityNumber].origin );

//  sprintf(qcs_message, "\n\n\n\n\n\n\n\n\n\n%-10s %10s %8.3f\n%d %d %d %c%c%c%c %8.3f  %8.3f\n%8.3f %8.3f %8.3f\n%s\n%8.3f %8.3f %8.3f %c%c%c %c%c%c%c\n", 
//	  (mbf_target>0?players[mbf_target-1].name : "none."), 
//	  (mbn_target>0?modeltable[ entities[mbn_target].index ]:"none"),
//	  (entities[mbn_target].origin-entities[myEntityNumber].origin).length(),
//	  map.getCurrentLeafType(),
//	  map.getCurrentLeaf(),
//	  map.getCurrentLinks(),
//	  map.leafHasFloor( map.getCurrentLeaf() )?'F':'.',
//	  roaming?'R':'.', 
//	  (orbit)?'O':'.',
//	  avoiding?'A':'.',
//	  mbn_velocity, 
//	  entities[myEntityNumber].velocity.length(),	
//	  entities[mbn_target].origin.getz() - entities[myEntityNumber].origin.getz(),
//	  roamAngle,
//	  (entities[mbn_target].origin-entities[myEntityNumber].origin).length(),
//	  mbotbase_localMessage,
//	  distToWallPlus15,
//	  distToWall,
//	  distToWallMinus15,
//	  leftBump?'L':'.',
//	  forwardBump?'F':'.',
//	  rightBump?'R':'.',
//	  sMoveAtTarget?'M':'.',
//	  sAvoidWall?'W':'.',
//	  sAvoidLava?'L':'.',
//	  sAvoidProjectile?'P':'.' );

  sprintf( qcs_message, "mikeBot version "MBOT_VERSION"\nhttp://www.planetquake.com/mikeBot\n" );


  mbotbase::update();
  mbfire::update();
  mbnav::update();
  mbtalk::update();

  if( isDead( myEntityNumber ) && !respawn )
    {
      printf( "I'm dead; respawning...\n" );
      mbf_target=-1;
      respawn = 30;
      map.died();
    }

  float theta, alpha;

  if( mbf_target == 0 )
    {
      facing = mbn_facing;
    }
  else
    {
      facing = mbf_facing;
    }

  theta = facing.getYaw();
  alpha = mbn_facing.getYaw();
	
  alpha = theta-alpha;

  alpha *= ((float)_PI/(float)180.0);

  forwardSpeed = (int)( ( cos(alpha) )*mbn_velocity );
  strafeSpeed = (int)( ( sin(alpha) )*mbn_velocity );
  verticleSpeed=0;

  sendMovement();
}


/*
**  sendMovement : overrides QCS::sendMovement
**
*/

int mbot::sendMovement()
{
  if( signonLevel < 3 )		// not connected
    return FALSE;

  float ts=(float)0.0;
  char actions=0;

  if( mbf_shoot == 1 ) { mbf_shoot = 0; actions |= 0x01; }
  else if ( mbf_shoot == 0 ) { mbf_shoot = 2; }
  if( mbn_jump >0 && mbn_jump <= 9 ) { mbn_jump--; if( mbn_jump%4 ) actions |= 0x02; else actions &= ~(0x02); }
  else if ( mbn_jump == 0 ) { mbn_jump = 10; }

  if( respawn ) { respawn--; if( respawn==15 ) actions = 0x03; else actions=0;}
      
  if( newTimestamp < oldTimestamp )
    {
      printf("mbot::sendMovement(): timestamp warning : %f, %f\n", newTimestamp, oldTimestamp);
      ts = oldTimestamp;
    }
  else
    {
      ts = newTimestamp;
    }

  ts += ((float)opts.get("timestamp-increment")/(float)100.0);

  outPacket.reset();				// start again
  outPacket.addBEint( outgoingUnreliable++ );	// unreliable packet
  outPacket.addByte( CS_ACTION );		// 0x03
  outPacket.addLEfloat( ts );			// timestamp
  outPacket.addAngle( facing.getPitch() );	// mbfire
  outPacket.addAngle( facing.getYaw() );	// mbfire
  outPacket.addAngle( (float)0.0 );			// <-- why need roll?
  outPacket.addLEshort( (short)forwardSpeed );	// mbnav, changed
  outPacket.addLEshort( (short)strafeSpeed);	// mbnav, changed
  outPacket.addLEshort( (short)verticleSpeed );	// mbnav, changed
  outPacket.addByte( actions );			// mbnav, mbfire
  outPacket.addByte( mbf_impulse );			// mbfire
  outPacket.changeType( qpacket::unreliable );	// calls qpacket::update() too

  if( mbf_impulse )
    mbf_impulse = 0;

#if DEBUG & DQCS
  if( outPacket.getNumber() > outgoingUnreliable )
    printf("*******************************\n");
#endif

  return send( outPacket );
}


/*
**  setOptsFromFile : initilization of user options
**
*/

int mbot::setOptsFromFile( char * fname )
{
  FILE * fp;
  char s[ 1024 ];
  char * a, *b;
  int val, i=0;
  int mode=0;

  if ( !(fp = fopen( fname, "r" )) )
    {
      perror("mbot::setOptsFromFile()");
      return FALSE;
    }

  while( fgets( s, 1024, fp ) )
    {
      val=0;
      while( s[val] )
	{
	  if( s[val] == '\n' )
	    s[val] = 0;
	  val++;
	}

      switch( s[0] )
	{
	case '\n':
	case '\0':
	case '#':		// comment character
	  break;

	case '*':		// special label character; check rest
	  if( !strncmp( "flags", &s[1], 5 ) )
	    mode = 1;
	  else if ( !strncmp( "servers", &s[1], 7 ) )
	    mode = 2;
	  else if ( !strncmp( "defaults", &s[1], 8 ) )
	    mode = 3;
	  else
	    fprintf(stderr, "mbot::setOptsFromFile(): `%s' unknown\n", &s[1] );
	  break;

	default:
	  if( mode == 0 )
	    fprintf(stderr, "mbot::setOptsFromFile(): line ignored\n");
	  else if (mode == 1)
	    {
	      a = strtok( s, " \t" );
	      b = strtok( NULL, " \t" );
	      val = atoi( b );
	      opts.set( a, val );
#if DEBUG & OPTS
	      printf("mbot::setOptsFromFile(): %s = %d\n", a, val );
#else
	      printf("%s = %d\n", a, val );
#endif
	    }
	  else if (mode == 2)
	    {
	      a = strtok( s, " \t");
	      b = strtok( NULL, " \t");
//	      strcpy( servers[i], a );
//	      strcpy( address[i], b );
	      i++;
#if DEBUG & OPTS
	      printf("mbot::setOptsFromFile(): `%s' at IP `%s'\n", a,b );
#else
	      printf("server `%s' at IP `%s'\n", a,b );
#endif
	    }
	  else if ( mode==3 )
	    {
	      if( !strncmp( s, "name", 4 ) )
		{
		  a = strtok( s, " \t" );
		  a = strtok( NULL, " \t" );
		  strncpy( qcs_botName, a, 20 );
#if DEBUG & OPTS
		  printf("mbot::setOptsFromFile(): bot name `%s'\n", qcs_botName);
#else
		  printf("bot name is %s\n", qcs_botName);
#endif
		}
	      else if ( !strncmp( s, "shirt", 5 ) )
		{
		  a = strtok( s, " \t" );
		  a = strtok( NULL, " \t" );
		  qcs_botShirt = atoi( a );
#if DEBUG & OPTS
		  printf("mbot::setOptsFromFile(): shirt = %d\n", qcs_botShirt);
#else
		  printf("bot shirt = %d\n", qcs_botShirt);
#endif
		}
	      else if ( !strncmp( s, "pants", 5 ) )
		{
		  a = strtok( s, " \t" );
		  a = strtok( NULL, " \t" );
		  qcs_botPants = atoi( a );
#if DEBUG & OPTS
		  printf("mbot::setOptsFromFile(): pants = %d\n", qcs_botPants);
#else
		  printf("bot pants = %d\n", qcs_botPants);
#endif
		}
	      else
		fprintf(stderr, "mbot::setOptsFromFile(): unknown default `%s'\n", s );
	    }
		  
	  break;
	}

    }

  fclose( fp );
  return TRUE;
}

  
