/*
**  graph class
**
**  (c) 1997 mike warren
**  mikeBot
**
**
**  builds a directed graph of the current level as the bot moves through
**  the level. as position is updates, this class figures out where the bot
**  is and if that new node has a floor polygon or is lava/slime/water, it
**  is added to the graph.  use the public: interface functions to get info
**  about the level. Provides line of sight, leaf type, etc
**
**  TODO:preprocess level (find shared plane between two nodes, link 'em)
**
*/


#ifndef _GRAPH_H_
#define _GRAPH_H_

#include "defines.h"
#include "bspfile.h"
#include "vector.h"
#include "stack.h"


struct table
{
  int dist;
  int p;
  table() { dist=-1; p=0; }
};

class queue
{
  int * entries;
  int start;
  int end;
  int num;
  int max;

public:
  queue( int size=1024 ) { entries=new int[ size ]; start=0; end=0; num=0; max=size; }
  ~queue() { delete[] entries; }

  void add( int x ) { if( num >= max ) return; entries[start]=x; start = ++start % max; num++; }
  int get() { if (num==0) return -1; end %= max; num--; return entries[ end++ ]; }

  int isEmpty() { return num==0; }

};

struct adjNode
{
  adjNode * next;
  int data;
  vector origin;
  
  adjNode( int x, vector & o ) { data=x; origin=o; next=0; }
  adjNode( int x, vector & o, adjNode * n ) { data=x; next=n; origin=o; }
};





class bspGraph
{

private:

  bspFile * map;

  vector position;
  vector oldPosition;

  int currentNode;
  int oldNode;
  int dead;			// if 1, the player just died

  char gfname[ Q_MAX_STRING ];	// name of graph-link file

  int listSize;
  adjNode ** adjList;		// vector of pointers to linked lists
  table * t;			// for shortest path
  int totalLinks;
  
  void updateTable( int );
  int findLeaf( vector );
  void eraseGraph();

public:

  bspGraph() { currentNode=oldNode=0;map=0;listSize=0; adjList=0; t=0; gfname[0]=0; dead=0; }
  ~bspGraph() { save(); delete map; eraseGraph(); }

  int save();
  int load();
  void updatePosition( vector );
  void died() { dead=1; }
  int getCurrentLeafType();
  int getCurrentLeaf() { return currentNode; }
  int getOldLeaf() { return oldNode; }
  int getCurrentLinks() { return numLinks( currentNode ); }

  int isShotBlocked( vector, vector * h=0 );
  int isLineBlocked( vector start, vector end, vector * hp=0, int lava=FALSE );

  int getLeafType( vector );
  int getLeaf( vector x ) { return findLeaf( x ); }
  int isLoaded() { return (map!=0); }

  stack< int > * findPath( int, int );
  int addLink( int, int, vector * l=NULL );
  int removeLink( int, int );
  int isLink( int, int );
  int numLinks( int );

  vector getLeafOrigin( int );

  int lineHitsLava( vector, vector);
  int pointOverLava( vector x ) { vector y=x; y.setz(x.getz()-32700); return lineHitsLava( x, y ); }

  const bspFile * getMap() { return map; }

  int newMap( char * fname, int noGraph=0 );

};

#endif
  

