/*
**
**  global defines 
**  mikeBot 
**  (c) 1997, mike warren
**
**  make sure QBIG_ENDIAN and QLITTLE_ENDIAN are #defined correctly. Also 
**  ensure that UNIX, AIX, and WIN32 are #defined appropriatly for your system
**  (if you are on AIX, make sure *BOTH* UNIX and AIX are #defined to 1
**
**  QTHROW, if TRUE, enables throw()'s from (mainly) qsocket; make sure your
**  compiler knows about these (gcc needs -fhandle-exceptions)
**
**  #undef DEBUG, or #define DEBUG 0 to turn off all debug code. (recommended,
**  since this spews out a *lot* of information)
**
*/


#ifndef _DEFINES_H_
#define _DEFINES_H_

#include <stdlib.h>

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
///
///   IMPORTANT : 
///
///   You MUST SET these first 4 #defines to your system. A Win95 PC must have
///   UNIX=0, AIX=0, WIN32=1 and QLITTLE_ENDIAN #defined.
///
///   A linux PC would have UNIX=1, AIX=0, WIN32=0, QLITTLE_ENDIAN, whereas
///   a unix box (non-AIX) would have UNIX=1, AIX=0, QBIG_ENDIAN
///
///   Also NOTE THAT I have (I think) named the endianesses wrong. As far as
///   this code is concerned, a PC (Intel chips) is QLITTLE_ENDIAN, and a
///   Motrolla-based computer is QBIG_ENDIAN
///
///   If you are using the Borland compiler, #define BORLAND to 1
///
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


#define UNIX  0			// machine type
#define AIX   0			// (AIX is a type of unix)
#define WIN32 1			// windows 95
#define QLITTLE_ENDIAN		// PC's (Intel) are QLITTLE_ENDIAN
#define BORLAND 0		// Borland Compiler (thanks Colin Skow)


//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

#define Q_MAX_STRING 1024	// pretty arbitrary; i think this is UNIX max
				// path length, too, though

#define QTHROW 1		// throw exceptions or not
#define QPROXY 0		// include proxy code


#define MBOT_VERSION    "0.31"

		// qpacket defines

#define QP_MAX_PACKET_DATA 	 1200	// 8 bytes header, plus 1024 max data

		// qcs defines


#define QCS_MAX_TIMEOUTS         5	// times to retry when connect()ing
#define QCS_DEFAULT_SERVER	"0.0.0.0"
#define QCS_DEFAULT_PORT	 26000
#define QCS_MAX_MODELS           255	// don't change this; id's hard limit
#define QCS_MAX_SOUNDS           255	// don't change these; id hard limits
#define QCS_MAX_ENTITIES	 450	// nor this.
#define QCS_FRAGMENT_BUFFER      10240	// size of fragment buffer in QCS
#define QCS_MAX_WAIT             2	// seconds to try on each connect() ( * QCS_MAX_TIMEOUTS)
#define QCS_RECONNECT_STRING	"reconnect."
#define QCS_MAX_PLAYERS		 16	// and id said "unlimited" :)

#define QCS_BOT_NAME		"-=mikeBot=-"
#define QCS_BOT_PANTS            3
#define QCS_BOT_SHIRT            3
#ifdef MIKEBOT
#define QCS_GREETING1		"mikeBot version "MBOT_VERSION""
#define QCS_GREETING2		"www.ucalgary.ca/~mbwarren/mikeBot/"
#define QCS_GREETING3		"say \"mbl-help\" for info."
#else
#define QCS_GREETING1           "based on mikeBot "MBOT_VERSION""
#define QCS_GREETING2           "client-server source, from"
#define QCS_GREETING3           "www.ucalgary.ca/~mbwarren/mikeBot/"
#endif


				// indexs into playerstate array

#define PS_AMMO    3
#define PS_HEALTH 0
#define PS_CELLS 9
#define PS_SHELLS 6
#define PS_ROCKETS 8
#define PS_NAILS 7
#define PS_WEAPON 10
#define PS_ARMOR 4

                 // bsp stuff
				// for BSP loading stuff

#define BSPD_ENTITIES 0
#define BSPD_PLANES 1
#define BSPD_TEXTURES 2
#define BSPD_VERTICES 3
#define BSPD_VISILIST 4
#define BSPD_NODES 5
#define BSPD_TEXINFO 6
#define BSPD_FACES 7
#define BSPD_LIGHTMAPS 8
#define BSPD_CLIPNODES 9
#define BSPD_LEAVES 10
#define BSPD_FACELIST 11
#define BSPD_EDGES 12
#define BSPD_EDGELIST 13
#define BSPD_MODELS 14


#define BSP_PLANE_SIZE 20
#define BSP_VERTEX_SIZE 12
#define BSP_NODE_SIZE 24
#define BSP_FACE_SIZE 20
#define BSP_CLIPNODE_SIZE 8
#define BSP_LEAF_SIZE 28
#define BSP_FACELIST_SIZE 2
#define BSP_EDGELIST_SIZE 4
#define BSP_EDGE_SIZE 4
#define BSP_MODEL_SIZE 64
#define BSP_FACE_SIZE 20
#define BSP_ENTITY_SIZE 1

				// proxy defines

#define QX_MAX_CLIENTS 4

				// mbtalk defines

#define MBT_PREFIX  "\017mbt\017"

				// acknowledge queue defines


#define QACK_MAX                30     // max packets in ack queue
#define QACK_MAX_TIMEOUT        3

				// mbotbase defines


#define FLAG_VISIBLE 0x01
#define FLAG_DEAD 0x02

				// major entity types

#define ET_AMMO   1
#define ET_WEAPON 2
#define ET_HEALTH 3
#define ET_PROJECTILE 4
#define ET_ITEM   5
#define ET_MISC   6
#define ET_ARMOR  7
#define ET_VIEWMODEL 8
#define ET_ENEMY  9
#define ET_RUNE 10

				// minor entity types

				// ammo types

#define ET_A_SHELLS 1
#define ET_A_CELLS  2
#define ET_A_ROCKETS 3
#define ET_A_NAILS  4

				// weapon types

#define ET_W_SSG  5
#define ET_W_NG   6
#define ET_W_SNG  7
#define ET_W_GL   8
#define ET_W_RL   9
#define ET_W_LG   10

				// health types

#define ET_H_15  11
#define ET_H_25  12
#define ET_H_100 13

				// projectile defines

#define ET_P_MISSILE 14
#define ET_P_SNG_NAIL 15		// perforator
#define ET_P_NG_NAIL 16
#define ET_P_GRENADE 53

				// item types

#define ET_I_BIOSUIT 17
#define ET_I_POP 18
#define ET_I_RING 19
#define ET_I_QUAD 20
#define ET_I_BACKPACK 44

				// armour types

#define ET_A_GREEN 21
#define ET_A_YELLOW 22
#define ET_A_RED 23

				// viewmodel types

#define ET_V_AXE 43
#define ET_V_SG 24
#define ET_V_SSG 25
#define ET_V_NG 26
#define ET_V_SNG 27
#define ET_V_GL 28
#define ET_V_RL 29
#define ET_V_LG 30

				// rune types

#define ET_R_E1 31
#define ET_R_E2 32
#define ET_R_E3 33
#define ET_R_E4 34

				// enemy types

#define ET_E_PLAYER 35
#define ET_E_GIBS 36
#define ET_E_DOG 37
#define ET_E_OGRE 38
#define ET_E_KNIGHT 39
#define ET_E_HELLKNIGHT 40
#define ET_E_FISH 41
#define ET_E_SHALRATH 42

				// misc types

#define ET_M_BODY 50
#define ET_M_ENTITY 51


				//
				// major sound types
				//

#define ST_PLAYER    1
#define ST_EXPLOTION 2
#define ST_ITEM      3
#define ST_WEAPON    4

				//
				//  minor sound types
				//

#define ST_P_GRUNT 10
#define ST_P_JUMP  12
#define ST_P_DEATH 13

#define ST_W_SG  20
#define ST_W_NG  21
#define ST_W_SNG 22
#define ST_W_SSG 23
#define ST_W_GL  24
#define ST_W_RL  25
#define ST_W_LG  26
#define ST_W_AXE 27

#define ST_I_AMMO    30
#define ST_I_BIGAMMO 31
#define ST_I_MEGAHEALTH 32
#define ST_I_RING    33
#define ST_I_POP     34
#define ST_I_ARMOUR  35
#define ST_I_SUIT    36
#define ST_I_RESPAWN 37

#define ST_E_RL      40
#define ST_E_GL      41

				// weapon status bar "lights"

#define W_AXE 0
#define W_SG 1
#define W_SSG 2
#define W_NG 4
#define W_SNG 8
#define W_GL 16
#define W_RL 32
#define W_LG 64

#ifndef TRUE
#define FALSE 0
#define TRUE !FALSE
#endif

		// debugging defines


#define DQP 	1		// debuging qpacket
#define DQS	    2		// debuging qsocket
#define DQCS    4		// debuging qcs
#define DQACK   8		// ack queue
#define DMBF    16		// mbfire
#define DMBN    32		// mbnav
#define DMB     64		// mbot
#define DQX     128		// qproxy
#define MBT     256		// mbtalk
#define MBM     512     // bspGraph
#define OPTS    1024	// setOptsFromFile

		// (bitwise) OR together the things to be debuged

#define DEBUG  (0)



/*
**   prototypes
**
*/

extern void parseName( unsigned char * );
extern void parseString( char * );
extern void printDefines();

#endif
