/*
**
**  QCS class 
**
**  (c) 1997, mike warren
**  mikeBot
**
**  handles client-server communications.
**  the only functions you *need* are qcs::connect() and qcs::server()
**  and qcs::update() every time data is available at the socket (qcs::getFD())
**
**  (note that the constructor *will*not* connect() to the server but that the
**  dtor *will* disconnect )
**
*/

#ifndef _QCS_H_
#define _QCS_H_

#include "defines.h"
#include "qpacket.h"
#include "qsocket.h"
#include "qproxy.h"
#include "qstruct.h"		// serverinfo
#include "qentity.h"
#include "qplayer.h"
#include "qack.h"		// acknowledge queue
#include "vector.h"
#include "options.h"


#include "csdefs.h"
#include "scdefs.h"


#include <stdio.h>

class qcs
{

private:
  qsocket  * sock;	// `new' binds and looks up address
  qcs( qcs & ){}		// can't call copy constructor

  char currentServerIP[ Q_MAX_STRING ]; // set with 'server()'

protected:

			///  Stuff for adding the 'target.mdl' crosshair

  int chEntity;
  int chFrame;
  int chIsVisible;
  qentity chQEntity;

  int addBaseline( qentity &, char * );
  int findFreeEntity();

  options opts;			// hash table of options

  char qcs_botName[ 80 ];
  int qcs_botPants;
  int qcs_botShirt;
  char * qcs_lastrule;

#if QPROXY
  qproxy * proxy;			// so "real" client can connect
#endif

  FILE * demoFP;		// if recording demo, this is non-null
  int demoPauseState;	// if TRUE, no packets will be written...

  char qcs_message[ 4096 ]; // will be written to .DEMos on each packet


  vector facing;		// actual facing; could be from mbnav or mbfire
						// used to write demo packet

  vector fireParticle, navParticle;
  

		// only allocate a coupla packets; less `new' calls.
		// the *fragments buffer is for prespawn; reliableFragments
		// and relibaleEnds are accumulated here, then decoded

  qpacket inPacket;			// incoming packets
  qpacket outPacket;		// outgoing packet
  qpacket * fragments;		// reliableFragments
  qpacket prespawns1;		// for recording demos half-way through
  qpacket prespawns2;		// for recording demos half-way through
  qpacket prespawns3;		// for recording demos half-way through

  int outgoingUnreliable;	// packet counts; important, since
  int outgoingReliable;		// packets are accepted or rejected
  int incomingReliable;		// based on these numbers...
  int incomingUnreliable;	// (??? reset on level change ???)

  int haveConnection;		// 1 if server has accepted connect

  qack ackQueue;			// handles reliable client-server packets


  serverInfo info;			// decodeControl,decodeMessages() fills tis
  char * result;			// result from last connect attempt

  float newTimestamp;		// current timestamp of server
  float oldTimestamp;		// old timestamp
  int signonLevel;			// are we playing yet? only if this is 3
  int myEntityNumber;		// into entity array

			// TODO : change these to ints representing model/sound
			//        types; easy to check for ears, firecontrol
  
  char * modeltable[ QCS_MAX_MODELS ]; // i.e. 'progs/player.mdl
  char * soundtable[ QCS_MAX_SOUNDS ]; // i.e. 'sounds/player/death1.wav'
  char m_modeltypes[ QCS_MAX_MODELS ]; // major type
  char modeltypes[ QCS_MAX_MODELS ];   // minor type
  int soundtypes[ QCS_MAX_SOUNDS ];    // sound types

  qentity entities[ QCS_MAX_ENTITIES ];	// these only structs; keep track of
  qplayer players[ QCS_MAX_PLAYERS ];	// entities/players (frags, etc.)

  int decodeControl( qpacket & );
  int decodeReliable( qpacket & );
  int decodeUnreliable( qpacket & );
  int decodeAcknowledge( qpacket & );
  int decodeQPacket( qpacket & );
  int decodeMessages( qpacket & );

  int send( qpacket & );	// handles acks for reliables packet, too

  void initTables();		// makes modeltable[], soundtable[] = 0
  void deleteTables();		// deletes and non-NULL entries
  void updateTableTypes();

	
public:

  qcs();
  virtual ~qcs() { delete sock; deleteTables(); }

  void changePort( int x ) { if( sock ) sock->changePort( x ); }

  void reinit();				// deletes everything, reconstructs

  int sendKeepalive();			// also NO-OP
  int sendDisconnect();			// unreliable; makes server happier
  virtual int sendMovement();	// OVERRIDE ME
  int sendConsole( char * );	// console command, like "say hi"

  int getSignonLevel() { return signonLevel; }

  int update();			// call ONLY IF the socket has data( SELECT() )

#if QPROXY
  int updateProxy() { if(proxy) proxy->update(); else return FALSE; return TRUE; }
  int proxyConnected() { if( proxy) return proxy->connected(); else return FALSE; }
  void sayProxy( char * x ) { if( proxy ) proxy->sayClient( x ); }
  void proxyDump() { if (proxy ) proxy->dumpClients(); }
  void proxyKickClient( int x ) { if(proxy) proxy->kickClient(x); }
  void proxyDestroyClient( int x ) { if(proxy) proxy->destroyClient(x); }
#endif

  int getFD() { if(sock) return sock->getFD(); else return -1; }
  char * connect();		// returns message if connection declined,
						// returns (char *)0 if connected successfully
  void disconnect();		// sends disconnect packet to server, too
  int recordDemo( char *);	// pass filename
  int stopDemo();			// stops demo and writes disconnect packet
  int pauseDemo() { demoPauseState = TRUE; return TRUE; }
  int unpauseDemo() { demoPauseState= FALSE; return TRUE; }
  int waitForPacket();		// up to QCS_MAX_WAIT seconds (CONTROL ONLY)

		// if connected, disconnects but DOES NOT CONNECT to the new
		// server (just binds the socket and looks up the IP, if
		// nessecary (i.e. ``quake.foobar.ca'' needs to be looked up)

  int server( char * ip, int port = 26000 );

  void name( char * x ) { char temp[100];strncpy( qcs_botName, x, 79 ); if(connected()) { sprintf(temp,"name \"%s\"\n",x); sendConsole(temp); }}
  void pants( int x ) { char temp[80]; if( x >= 0 && x <= 13 ) qcs_botPants=x; sprintf(temp,"color %d %d\n", qcs_botShirt, qcs_botPants); if( connected() ) sendConsole( temp ); }
  void shirt( int x ) { char temp[80]; if( x >= 0 && x <= 13 ) qcs_botShirt=x; sprintf(temp,"color %d %d\n", qcs_botShirt, qcs_botPants); if( connected() ) sendConsole( temp ); }

			// these functions all return TRUE/FALSE and are
			// fairly self-explanatory...

  int connected() { return (haveConnection) ? TRUE : FALSE; }
  int recording() { return (demoFP) ? TRUE : FALSE; }
  
			// some helpful(ish) output functions

  void printInfo();				// prints (after getting) server info
  void printPlayerInfo( int );	// gets player info, prints it
  void printAllPlayers();		// prints all active players
  void printRules();			// prints all rules, values
  void printLevel() {printf("level is '%s' (%s)\n",info.level,modeltable[1]);}

			// any BOT class should override these;
			// (i.e. override them, ya dummy! ;) )
			// they are called when the event they name
			// happens...fairly self-explanatory
  void rankings();

  virtual void changedLevel( char * x ){ printf("QCS:level `%s'\n", x ); }
  virtual void consoleCommand( char * x ) { printf("QCS:console `%s'\n",x); }
  virtual void entityUpdated( int x ){ printf("QCS:entity %d\n", x ); }
  virtual void entityChanged( int x ) { printf("QCS:new entity %s\n", modeltable[entities[x].index] ); }
  virtual void timestampChanged( float x ){ printf("QCS:time %f\n",x); }
  virtual void playerstateUpdate( int i,int v ) { printf("QCS:%d is %d\n",i,v);}
  virtual void gotSayMessage( char * x ) { printf("QCS:%s\n", x ); }
  virtual void receivedDamage( int amt, vector & v ) { printf("QCS:damage : %d from ",amt);v.print(); printf("\n"); }
  virtual void centerPrint( char * x ) { printf("QCS:cprint `%s'\n", x); }

  virtual void updateHealth( int x ) { printf("QCS:health %d\n",x); }
  virtual void updateArmour( int x ) { printf("QCS:armour %d\n",x); }
  virtual void updateCells( int x ) { printf("QCS:cells %d\n", x); }
  virtual void updateShells( int x ) { printf("QCS:shells %d\n",x ); }
  virtual void updateRockets( int x ) { printf("QCS:rockets %d\n", x); }
  virtual void updateNails( int x ) { printf("QCS:nail %d\n", x); }
  virtual void updateWeapon( int x ) { printf("QCS:weapon %d\n", x); }
  virtual void updateItems( int x ) { printf("QCS:items %d\n", x); }


};

#endif
