/*
**
**  MBNAV class 
**
**  (c) 1997, mike warren
**  mikeBot
**
**  ROAM version
**
**  handles navigation : has complete control over idealSpeeds, which are
**  changed to actual speeds after facing is determined (by mbfire). Also 
**  controls jumping. (unused, basically)
**
** TODO : pretty much everything :)
**
*/

#ifndef _MBNAV_H_
#define _MBNAV_H_

#include "mbfire.h"
#include "stack.h"

class mbnav : public mbfire
{
protected:

  vector mbn_facing;		// where nav system wants to go
  float mbn_velocity;		// target speed

  int mbn_jump;			// turned off after send

  float orbitAngle;		// for circle-strafe around players
  float roamAngle;		// actual angle
  vector targetOrigin;		// where I'm really going
  
  float moveAtTargetAngle;
  float avoidWallAngle;
  float avoidProjectileAngle;
  float avoidLavaAngle;

  char sAvoidWall;
  char sAvoidProjectile;
  char sAvoidLava;		// can't acually ever supress this
  char sMoveAtTarget;

  char forwardBump;
  char leftBump;
  char rightBump;
  char lastTurn;

  float distToWall;
  float distToWallPlus15;
  float distToWallMinus15;

  int roaming;			// bool ("random" movement)
  int avoiding;			// bool (running away)
  int orbit;			// bool (circle strafe)

  int mbn_oldTarget;		// previous target

  float stoppedTimestamp;		// how long ago mikeBot stoped moving

  void jump() { if( mbn_jump == 10) mbn_jump = 9; }

  int aimAt( int );		// aims at an entity (sets mbn_facing)
  int aimAt( vector & );	// faces the point
  int aquireTarget( int );	// gets a new target

  void selectTarget();
  void bendFacing();		// bends to avoid lava, projectiles
				// can also play with mbn_velocity
  void adjustFacing();		// avoids walls
  void updateDistances();	// computes dist. to walls (+-15 degress)

  void moveAtTarget();		// runs straight to target
  void avoidWall();		// if wall ahead, turns away
  void avoidLava();		// turns away from lava
  void avoidProjectile();	// moves orthogonal to missiles, etc.

  void turnLeft( float &  );
  void turnRight( float & );
  void turn( float & );

public:

  mbnav();
  ~mbnav() { }
  
  void forceJump() { jump(); }
  void mbn_printTarget() { if( mbn_target != -1 ) printf("`%s'", modeltable[ entities[mbn_target].index ]); else printf("`none'"); }
  void dumpPath();


  void update();

};





#endif

