/*
**
**  MBNAV class 
**
**  (c) 1997, mike warren
**  mikeBot
**
**  uses ROAMING code (see doc. for more)
**
**  handles navigation : has complete control over idealSpeeds, which are
**  changed to actual speeds after facing is determined (by mbfire). Also 
**  controls jumping. (unused, basically)
**
** TODO : pretty much everything :)
**
*/

#include "defines.h"
#include "mbnav.h"
#include <math.h>		// fmod()
#include <stdio.h>

/*
**  ctor
**
*/

mbnav::mbnav()
{ 
  mbn_facing.set( (float)0.0,(float)0.0,(float)0.0 ); 

  mbn_jump=10; 

  orbit=FALSE;
  avoiding=FALSE;
  roaming=FALSE;

  orbitAngle=(float)0.0;
  roamAngle=(float)0.0;
  
  mbn_target = 0;
  mbn_oldTarget = 0;

}

/*
**  aimAt : changes idealSpeeds to face the target.
**
**     returns FALSE if the entity is not visible or illegal(i.e. OOB)
*/

int mbnav::aimAt( int x )
{
  if( x <= 0 || x > QCS_MAX_ENTITIES )
    return FALSE;
  if( !isVisible( x ) )
    return FALSE;

  if( !isProjectile( x ) )
    {
      if( !isPlayer( x ) )
	{
//	  mbn_facing = entities[myEntityNumber].origin - entities[x].origin;
	  aimAt( entities[x].origin );
	  return TRUE;
	}
      else
	{
	  aimAt( entities[x].origin );
	  return TRUE;
	}
    }



//  mbn_facing = entities[x].origin - entities[myEntityNumber].origin;

				// must avoid it...

  vector unitZ((float)0,(float)0,(float)1);
  vector tv = entities[myEntityNumber].origin - entities[x].origin;
  tv.X( unitZ );

  tv.normalize();
  tv *= (float)320.0;

  vector tv3 = tv;
  tv3 *= (float)-1.0;

  if( (entities[x].origin - tv).length() > (entities[x].origin-tv3).length() )
    mbn_facing = tv;
  else
    mbn_facing = tv3;

  return TRUE;

}

int mbnav::aimAt( vector & v )
{
  if( !isPlayer( mbn_target ) )
    {
      mbn_facing = entities[myEntityNumber].origin - v;
      roamAngle = mbn_facing.getYaw();
      return TRUE;
    }

  vector tv;

  if( !opts.get( "orbit-speed" ) )
    orbitAngle += (float)10.0;
  else
    orbitAngle += (float)opts.get( "orbit-speed" );
  orbitAngle = (float)fmod( orbitAngle, (float)360.0 );

  tv.setFromPY( (float)0.0, orbitAngle );
  tv.normalize();
  tv *= (float)96.0;

  tv += v;

  mbn_facing = entities[myEntityNumber].origin - tv;
//  roamAngle = mbn_facing.getYaw();

  return TRUE;

}

/*
**  update : picks a target and goes for it (now just picks first visible 
** 	     non-player thing it sees
**
*/


void mbnav::update()
{

  vector tv;

  if( stoppedTimestamp > 0.0 )
    if( entities[myEntityNumber].velocity.length() >= 5.0 )
      stoppedTimestamp = (float)0.0;

  if( entities[ myEntityNumber ].velocity.length() < 5.0 && stoppedTimestamp == 0.0 )
    stoppedTimestamp = newTimestamp;

  selectTarget();		// pick something interesting

  if( mbn_target )		// in case it's moving...
    targetOrigin = entities[mbn_target].origin;

  updateDistances();		// sensor inputs...


  sMoveAtTarget=FALSE;
  sAvoidWall=FALSE;
  sAvoidProjectile=FALSE;
  sAvoidLava=FALSE;

  moveAtTarget();
  avoidWall();
  avoidProjectile();
  avoidLava();

/*
  if( !sMoveAtTarget )
    roamAngle = moveAtTargetAngle;
*/
  if ( !sAvoidWall )
    roamAngle = avoidWallAngle;
  else if ( !sAvoidProjectile )
    roamAngle = avoidProjectileAngle;
  else if ( !sAvoidLava )
    roamAngle = avoidLavaAngle;

  mbn_velocity = (float)320.0;

  roamAngle = (float)fmod( roamAngle, 360.0 );
  mbn_facing.setFromPY( (float)0.0, roamAngle );

  if( entities[mbn_target].origin.getz() - entities[myEntityNumber].origin.getz()  > 80.0 )
    if( !opts.get( "no-jump" ) )
      jump();	

				// check for water

  if( map.getCurrentLeafType() == 2 )
    if( !opts.get( "no-swim" ) )
      jump();

				// avoid lava, slime (maybe water)
  if( !opts.get( "no-avoid-lava" ) )
    {
      vector tv = mbn_facing;
      vector tvv = entities[myEntityNumber].velocity;
      tv.normalize();
      tvv.normalize();
      tv *= (float)-64.0;
      tvv *= (float)-64.0;
      tv.setz( (float)0.0 );
      tvv.setz( (float)0.0 );
      tv += entities[myEntityNumber].origin;
      tvv += entities[myEntityNumber].origin;
      vector tv2 = tv;
      vector tv3 = tvv;
      tv2.setz( tv.getz()-(float)32700.0 );
      tv3.setz( tvv.getz()-(float)32700.0 );
      
      int i = map.isLineBlocked( tv, tv2,0,TRUE );
      int j = map.isLineBlocked( tvv, tv3,0,TRUE );

      if( i==4 || i==3 || j==4 || j==3 )
	{
	  mbn_velocity=(float)-1.0;
//	  roamAngle += 180.0;
//	  roamAngle = fmod( roamAngle, 360.0 );
	}

      if( opts.get( "avoid-water" ) && (i == 2 || j==2) )
	mbn_velocity = (float)-1.0;
    }

  if( opts.get("no-move" ) )
    mbn_velocity = (float)0.0;


}

/*
**  selectTarget : gets a nav target. If fireTarget != 0, then it will only
**                 go after something else if health/ammo low
**
*/


void mbnav::selectTarget()
{
  float bestRate,rate;
  int bestTarget;
  int i;
  vector tv;
  float pitch;

  if( mbf_target )
    {
      bestRate = (health*health)/(float)40;
      bestRate = bestRate / (entities[myEntityNumber].origin - entities[mbf_target].origin).length();
      bestTarget = mbf_target;
    }
  else
    {
      bestRate = (float)0;
      bestTarget = 0;
     }

  for( i=info.maxPlayers; i < QCS_MAX_ENTITIES; i++ )
    if( isVisible( i ) )
      {
	if( isHealth( i ) )
	    if( health > 50 )
	      rate = (float)(100-health)*2;
	    else
	      rate = (float)(100-health)*4;
	else if( isShells( i ) )
	  rate = (float)(100-shells);
	else if ( isCells( i ) && haveLG() )
	  rate = (float)(100-cells)/2;
	else if ( isRockets( i ) && haveRL() )
	  rate = (float)(200-rockets)/2;
	else if( isNails( i ) && (haveNG()||haveSNG())  )
	  rate = (float)(200-nails)/2;
	else if ( isArmour( i ) )
	  rate = (float)(100-armour)/2;
	else if ( isLG( i ) && !haveLG() )
	  rate = (float)110;
	else if ( isRL( i ) && !haveRL() )
	  rate = (float)100;
	else if ( isSNG( i ) && !haveSNG() )
	  rate = (float)100;
	else if ( isSSG( i ) && !haveSSG() )
	  rate = (float)105;
	else if ( isNG( i ) && !haveNG() )
	  rate = (float)100;
	else if ( isBackpack( i ) )
	  rate = (float)102;
	else if ( isPowerup( i ) )
	  rate = (float)100;
	else
	  rate = (float)0;

	entities[i].rate = (int)rate;

	rate *= (float)100.0;

	if( i == mbn_target )
	  rate *= (float)2.0;

	tv = entities[myEntityNumber].origin-entities[i].origin;
	rate /= tv.length();
	pitch = tv.getPitch();
	if( pitch < 0.0 )
	  pitch = -pitch;
	if( pitch != 0.0 )
	  rate /= pitch;

	if( rate > bestRate )
	  {
	    bestRate=rate;
	    bestTarget = i;
	  }
      }


  if( bestTarget != mbn_target && bestTarget )
    {
      mbn_oldTarget = mbn_target;
      mbn_target = bestTarget;
      aimAt( mbn_target );
#if DEBUG & DMBN
      printf("mbnav::selectTarget(): new target `%s'\n", modeltable[ entities[mbn_target ].index ] );
#endif
    }

}

  
/*
**  bendFacing : adjusts angle for projectiles, lava
**
**  TODO : lava
**
*/

void mbnav::bendFacing()
{
  float rate;
  float bestRate=(float)0.0;
  int i, index=-1;

  for( i=0; i < QCS_MAX_ENTITIES; i++ )
    {
      rate=(float)0.0;
      if( isVisible( i ) && isProjectile( i ) && willHitMe( i ) )
	rate = (float)2000.0;

      if( rate > 0.0 )
	rate /= (entities[i].origin - entities[myEntityNumber].origin).length();

      if( rate > bestRate )
	{
	  bestRate = rate;
	  index=i;
	}
    }

  avoiding=FALSE;

  if( index==-1 )
    return;

  avoiding=TRUE;

  vector unitz((float)0.0,(float)0.0,(float)1.0);

  if( !isGrenade( index ) )
    {
      vector tv = entities[myEntityNumber].origin - entities[index].origin;
      tv.X( unitz );

      tv.normalize();
      tv *= (float)320.0;

      vector tv3 = tv;
      tv3 *= (float)-1.0;

      if( (entities[index].origin - tv).length() > (entities[index].origin-tv3).length() )
	mbn_facing = tv;
      else
	mbn_facing = tv3;

      if( mbn_velocity != -1.0 )
	mbn_velocity = (float)320.0;
    }
  else
    {
      aimAt( entities[index].origin );
      mbn_facing = -mbn_facing;
    }

}

      

/*
**      
**  adjustFacing : avoids walls, doesn't run off cliffs
**
**  TODO:ledges
**
*/

void mbnav::adjustFacing()
{

  float delta;

  if( (newTimestamp - stoppedTimestamp) > 2.0 && stoppedTimestamp > 0.0 )
    {
#if DEBUG & DMBN
      //      printf("mbnav::adjustAngle(): random angle\n");
#endif
      if( opts.get( "random" ) )
	roamAngle = (float)(rand()%360);
    }

  delta=(float)0.0;

  if( distToWall < (float)opts.get( "front-threshhold" ) )
    if( distToWallPlus15 < distToWallMinus15 )
      delta += (float)5.0;
    else
      delta -= (float)5.0;

  roamAngle += delta;
  roamAngle = (float)fmod( roamAngle, 360.0 );

  mbn_facing.setFromPY( (float)0.0, roamAngle );
	
}
  

  
/*
**  dumpPath 
**
*/

void mbnav::dumpPath()
{
}


/*
**  updateDistances : updates distToWall's
**
**  TODO : perhaps pitch sensors up a bit...(stairs, etc...)
**
*/

void mbnav::updateDistances()
{
  vector tv;
  float angle;

  tv = mbn_facing;

  tv.normalize();
  tv *= -(float)opts.get( "front-threshhold" );
  distToWall = map.distanceToWall( tv );
  tv += entities[myEntityNumber].origin;
  forwardBump = map.isShotBlocked( tv );

  angle = mbn_facing.getYaw()-90;
  angle = (float)fmod( angle, 360.0 );
  tv.setFromPY( (float)0.0, angle );
  tv.normalize();
  tv *= -(float)opts.get( "front-threshhold" );
  distToWallMinus15 = map.distanceToWall( tv );
  tv += entities[myEntityNumber].origin;
  rightBump = map.isShotBlocked( tv );

  navParticle = tv;
  

  angle = mbn_facing.getYaw()+90;
  angle = (float)fmod( angle, 360.0 );
  tv.setFromPY( (float)0.0, angle );
  tv.normalize();
  tv *= -(float)opts.get( "front-threshhold" );
  distToWallPlus15 = map.distanceToWall( tv );
  tv += entities[myEntityNumber].origin;
  leftBump = map.isShotBlocked( tv );

				// if stopped, assume wall is being hit

  if( entities[myEntityNumber].velocity.length() < 100.0 )
    forwardBump = TRUE;

}


/*
**  various subsumtive routines; some can supress others
**
*/

/*
**  supresses : nothing
**
*/

void mbnav::moveAtTarget()
{
  if( sMoveAtTarget )
    return;

  vector tv;

  if( mbn_target && !rightBump && !leftBump && !forwardBump )
    {
      tv = entities[myEntityNumber].origin - entities[mbn_target].origin;
      moveAtTargetAngle = tv.getYaw();
    }
}

/*
**   supresses : moveAtTarget
**
*/

void mbnav::avoidWall()
{

  if( sAvoidWall )
    return;

  avoidWallAngle = roamAngle;

  if( stoppedTimestamp > 0.0 && (newTimestamp-stoppedTimestamp)>5.0 )
    lastTurn = !lastTurn;

/*
  if( leftBump && !rightBump )
    turnRight( avoidWallAngle );

  if( rightBump && !leftBump )
    turnLeft( avoidWallAngle );
*/

  if( forwardBump )
    turn( avoidWallAngle );

  if( avoidWallAngle != roamAngle )	// supress moveAtTarget
    sMoveAtTarget = TRUE;
  else
    sAvoidWall = TRUE;		// supress myself; nothing to avoid

}


/*
**   supresses : avoidWall, moveAtTarget
**
*/

void mbnav::avoidProjectile()
{
  if( sAvoidProjectile )
    return;

  sAvoidProjectile = TRUE;	// supress myself

}


/*
**   supresses : everything (this is lava...) ;)
**
*/

void mbnav::avoidLava()
{
  if( sAvoidLava )
    return;
/*

  vector tv = mbn_facing;
  tv.setz( 0.0 );
  tv.normalize();
  tv *= 128.0 + (((float)opts.get( "latency" )*32.0)/100.0);
  tv += entities[myEntityNumber].origin;
  vector tv2 = tv;
  tv2.setz( -32700.0 );

  int i = map.isLineBlocked( tv, tv2, NULL, TRUE );

  if( i==4 || i==3 )
    {
      sAvoidWall=TRUE;
      sMoveAtTarget = TRUE;
      sAvoidProjectile=TRUE;
      avoidLavaAngle = roamAngle + 10.0;
    }
  else
*/
    sAvoidLava = TRUE;		// supress myself

}

  
/*
**  turn functions : turn in the desired direction and set lastTurn 
**                   accordingly. turn() turns in lastTurn's direction
**
*/

void mbnav::turnLeft(float & x )
{
  x += (float)10.0;
  x = (float)fmod( x, 360.0 );
  lastTurn = 0;
}

void mbnav::turnRight( float & x )
{
  x -= (float)10.0;
  x = (float)fmod( x, 360.0 );
  lastTurn=1;
}

void mbnav::turn( float & x )
{
  if( lastTurn )
    x -= (float)10.0;
  else
    x += (float)10.0;

  x = (float)fmod( x, 360.0 );
}

