/*
**
**  Mbfire class 
**
**  (c) 1997, mike warren
**  mikeBot
**
**
**  handles firecontrol : has 100% control of facing info and ``fire'' flag,
**  as well as impulses ( weapon switching )
**
*/

#include "defines.h"
#include "mbfire.h"
#include <math.h>
#if WIN32
#include <float.h>
#endif

/*
**  ctor : inits variables
**
*/

mbfire::mbfire()
{
	mbf_target = 0;
	mbf_oldTarget = 0;
	
	mbf_shoot = 2;		// 2 == inactive, 1 = shoot, 0 = send 0
	mbf_impulse = 0;	// if impulse != 0, it is sent, then set=0

	mbf_facing.set( (float)0.0, (float)0.0, (float)0.0 );
}

/*
**  aimAt : makes the bot aim at the specified entity number. FALSE is returned
**  	    if the facing was not changed, for the following reasons:
**
**     +  the entity is dead (or non-living; i.e. health, ammo).
**     +  the entity is not visible.
**     +  the entity number is invalid (==0, or > QCS_MAX_ENTITIES)
**
**  TODO : adjust for lag and projectile velocity depending on weapon,
**	   entity speed, my velocity.
**
*/

int mbfire::aimAt( int targetEntity )
{
  if( targetEntity > QCS_MAX_ENTITIES || targetEntity < 1 )
    return FALSE;
  else if ( !isVisible( targetEntity ) )
    return FALSE;
  else if ( isDead( targetEntity ) )
    return FALSE;
  else if ( players[targetEntity-1].hate < 0 )
    return FALSE;

  mbf_oldTarget = mbf_target;
  mbf_target=targetEntity;
  predictPosition();

  char temp[80];

				// mess with predictedPosition according
				// to hate, frags

  if( opts.get( "sometimes-miss" ) || opts.get( "skill" ) )
    {

      float hitProb=(float)100.0;
  
      if( players[targetEntity-1].frags > players[myEntityNumber-1].frags )
	hitProb=(float)100.0;
      else 
	{
	  if( maxHate > 0.0 )
	    hitProb = (float)players[targetEntity-1].hate / (float)maxHate;
	  else
	    hitProb = (float)0.5;
	  if ( hitProb < 0.5 )
	    hitProb = (float)0.5;
	  hitProb *= (float)100.0;
	}

      if( opts.get( "skill" ) )
	hitProb = (float)opts.get("skill");
      
      if( opts.get( "print-hitprob" ) )
	printf("hitProb = %f\n", hitProb );

      if( (rand()%100) > hitProb )	// miss a little
	{
	  hitProb = (float)(rand()%128);
	  hitProb += (float)32.0;
	  if( opts.get( "print-hitprob" ) )
	    printf( "miss vector length=%f\n", hitProb );

	  sprintf(temp,"missing; miss-vector %f long", hitProb );
	  sayLocal( temp );

	  vector tv = entities[targetEntity].facing;
	  tv.normalize();
	  tv *= hitProb;
	  mbf_predictedPosition += tv;
	}
    }
      

  mbf_facing = entities[myEntityNumber].origin - mbf_predictedPosition;

  return TRUE;
}

/*
**  update : performs any targeting calculations, etc.
**
*/

void mbfire::update()
{
	int i;
	float bestRate=(float)0;
	float rate=(float)0;
	int best=0;

//	if( mbf_target == 0 )
//	  {
	    for( i=1; i <= info.maxPlayers; i++ )
	      if( isVisible( i ) && !isDead( i ) && i != myEntityNumber && players[i-1].hate >= 0 )
		{
		  rate = (float)100.0;
		  rate /= (entities[i].origin - entities[myEntityNumber].origin).length();

		  if( rate > bestRate )
		    {
		      bestRate = rate;
		      best = i;
		    }
		}
//	  }

	if( best )
	  mbf_target = best;

	if( !aimAt( mbf_target ) )
	  {
	    mbf_target = 0;
	    if( opts.get( "target-record" ) )
	      pauseDemo();
	  }
	else
	{
	  selectWeapon();
	  unpauseDemo();

	  chIsVisible = FALSE;

	  if( !map.isShotBlocked( mbf_predictedPosition, &fireParticle ) )
	  {
	    if( !opts.get( "no-fire" ) )
		{
			fire();
			chIsVisible = TRUE;
			chQEntity.origin = entities[ mbf_target ].origin;
			chQEntity.facing = entities[ mbf_target ].facing;


			chQEntity.frame++;
			if( chQEntity.frame > 35 )
				chQEntity.frame = 0;
		}
	  }

	     
	}

	return ;

}

/*
**  selectWeapon : bases weapon selection on ammo, range
**
*/

void mbfire::selectWeapon()
{

  float range = mbf_facing.length();

  if( haveLG() && cells && weapon != 256 && range < 256.0 )
    {
      if( map.getCurrentLeafType() != 2 )	// check water situation
	mbf_impulse = 8;
    }
  else if ( haveRL() && rockets && weapon != 128 && range > 256.0 )
    {
      if( map.isLoaded() )
	mbf_impulse = 7;
    }
  else if ( haveSNG() && nails && weapon != 32 )
    mbf_impulse = 5;
  else if ( haveSSG() && shells && weapon != 2 )
    mbf_impulse = 3;
  else if ( haveNG() && nails && weapon != 4 && !haveSNG() && !opts.get( "no-NG" ))
    mbf_impulse = 4;
  else if ( shells && weapon != 1 && !haveSSG() )
    mbf_impulse = 2;
//  else if ( weapon != 0 )
//    mbf_impulse = 1;

}
  
      



/*
**  predictPosition
**
*/

void mbfire::predictPosition()
{

  float weapVel;

  switch( weapon )
    {
    case 0:			// axd
    case 1:			// SG
    case 2:			// SSG
    case 64:			// LG
      weapVel=(float)0.0;
      break;

    case 4:			// NG
    case 8:			// SNG
    case 32:			// RL
      weapVel=(float)1000.0;
      break;

    default:
      weapVel=(float)500.0;
    }

  if( opts.get( "no-predict" ) )
    {
      mbf_predictedPosition = entities[ mbf_target ].origin;
//      fireParticle = mbf_predictedPosition;
      return;
    }

  if( weapVel == 0.0 )
    {
      mbf_predictedPosition = entities[ mbf_target ].origin;
//      fireParticle = mbf_predictedPosition;
      return;
    }

  float time=(float)0.0,guess,err;
  vector tv;
  float enemyVel = entities[ mbf_target ].velocity.length();
  int times=0;

  do {
    tv = entities[ mbf_target ].velocity;
    tv.normalize();
    tv *= (enemyVel*time);
    tv += entities[ mbf_target ].origin;
    guess = ((entities[myEntityNumber].origin - tv).length() / weapVel) + ((float)opts.get( "latency" )/100);
    err = guess - time;
    if ( err < 0.0 )
      err = -err;
    time = guess;
    times++;
  }while( err > 0.01 && times < 6);

#if WIN32
  if( !_isnan( guess ) )
#else
  if( !isnan( guess ) )
#endif
    mbf_predictedPosition = tv;
  else
    mbf_predictedPosition = entities[ mbf_target ].origin;

//  fireParticle = mbf_predictedPosition;

}
