/*
**
**  main program : interprets user commands
**
**  (c) 1997 mike warren
**  mikeBot
**
*/

#include "mbot.h"
#include "cmdflags.h"
#include <ctype.h>

#ifdef __GNUC__
#include "stack.h"
template class stack< int >;
void terminate() { printf("terminated\n"); }
#endif

#if WIN32
#include <conio.h>
#endif

void printGreeting()
{
	printf("+------------------------------------------------+\n");
	printf("|  mikeBot version "MBOT_VERSION" (c) 1997 mike warren     |\n");
	printf("+------------------------------------------------+\n");
	printf("|  Visit the mikeBot Project on the Web at:      |\n");
	printf("|                                                |\n");
	printf("|       http://www.planetquake.com/mikeBot/      |\n");
	printf("|                                                |\n");
	printf("|  Direct any bug reports/problems/suggestions   |\n");
	printf("|  to Mike Warren at:                            |\n");
	printf("|                                                |\n");
	printf("|       mbwarren@acs.ucalgary.ca                 |\n");
	printf("|                                                |\n");
	printf("+------------------------------------------------+\n");
#if WIN32
	printf("|  This is the Windows 95 version, running on a  |\n");
#elif AIX
	printf("|  This is the AIX (Unix) version, running on a  |\n");
#else
	printf("|  This is the Unix version, running on a        |\n");
#endif
#ifdef QLITTLE_ENDIAN
	printf("|  Motrolla-based machine.                       |\n");
#else
	printf("|  Intel-based machine.                          |\n");
#endif
	printf("+------------------------------------------------+\n\n");
	printf(" **  Type '?' for help   **\n\n");

}

void displayUnconnectedHelp()
{
  printf("commands (case *sensitive*)\n\n");
  printf("s <ip/name>      change current server\n");
  printf("i                info on current server\n");
  printf("q                quit\n");
}


void displayConnectedHelp()
{
  printf("commands (case *sensitive*)\n\n");
  printf("h <playernumber> makes the hatelevel of playernumber -500\n");
  printf("a                prints armour health, ammo, weapons\n");
  printf("j                jump; forces bot to jump\n");
  printf("r <filename>     start recording demo\n");
  printf("R                stop recording\n");
  printf("f <flag> <value> sets flag to value (integer)\n");
  printf("F <flag>         prints the value of flag\n");
  printf("i <value>        sends the impulse value\n");
  printf("l                prints the current level\n");
  printf("t                prints current mbfire and mbnav targets\n");
  printf("q                disconnect\n");
  printf("v                prints all visible entities and the mbnav rating\n");
  printf("p                prints all active players and kills, colours\n");
  printf("c [string]       send string as a console command\n");
  printf("e                prints info. on all player entities\n");
  printf("s <string>       sends say message\n");
  printf("?                help (connected/unconnected)\n");

}


int main( int argc, char *argv[] )
{

  fd_set a;
  char in[ 1025 ];
  char out[ 1025 ];
  int i, x;

  cmdFlags * cf = new cmdFlags( argc, argv );
  mbot * bot = new mbot;
  char * r;

  bot->setOptsFromFile( cf->configfile );
  printDefines();		// prints out preprocessor #defines

  if( cf->address && !cf->port )
    bot->server( cf->address, 26000 );
  else if ( cf->address && cf->port )
    bot->server( cf->address, cf->port );
  else if ( !cf->address )
    bot->server( "136.159.102.88", 26000 );

  if( cf->filename )
    if ( !bot->recordDemo( cf->filename ) )
     perror( cf->filename );
    else
      ;
  else
    printf("Not recording demo\n");


  printGreeting();


  int running=1;
  struct timeval tv;
  tv.tv_sec = 2;
  tv.tv_usec = 2000;
#if WIN32
  int dataP=0;
  int isData=0;
#endif

  int maxFd=0;

  while( running )
    {
      FD_ZERO( &a );
#if !WIN32
      FD_SET( 0, &a );     /// sadly, can't select() on stdin in windows
#endif

      if( bot->getFD() > maxFd )
		maxFd = bot->getFD();

      if( bot->getFD() != -1 )
		FD_SET( bot->getFD(), &a );
      if ( (select( maxFd+10, &a, 0, 0, &tv )) < 0 )
		perror("select");

#if WIN32
	  while( kbhit() )
	  {
		  in[ dataP ] = getch();
		  putchar( in[ dataP ] );
		  if( in[ dataP ] == '\n' || in[ dataP ] == '\r' )
		  {
			  isData = TRUE;
			  dataP=0;
			  break;
		  }
		  dataP++;
	  }
#endif

#if !WIN32
      if( FD_ISSET( 0, &a ) )
	  {
		memset( in, 0, 1024 );
		read( 0, in, 1024 );
#else
	  if( isData )
	  {
		  isData = FALSE;
#endif
		for( i=0; in[ i ] != '\n' && in[ i ] != '\r'; i++ )
		    if( i >= 1023 ) break;
		in[ i ] = 0;

	  switch( in[0] )
	    {
	    case 'h':
	      i = atoi(&in[2]);
	      bot->changeHate( i, -500 );
	      break;

	    case 'H':
	      i = atoi(&in[2]);
	      bot->changeHate( i, 500 );
	      break;

	    case 'a':
	      printf("Ammo ");
	      bot->printAmmo();
	      break;

	    case 'j':
	      printf("Jump\n");
	      bot->forceJump();
	      break;
	    case 'r':
	      printf("Record demo `%s'\n", &in[2]);
	      if( !bot->recordDemo( &in[2] ) )
		perror( &in[2] );
	      else
		printf("Recording\n");
	      break;
	      
	    case 'R':
	      printf("stop Recording\n");
	      bot->stopDemo();
	      break;
	      	      
	    case 'f':
	      for( i=2; i < 1024; i++ )
		if( in[i] == ' ' )
		  {
		    in[i] = 0;
		    break;
		  }
	      x = atoi( &in[i+1] );
	      printf("set Flag %s = %d\n", &in[2], x);
	      bot->set( &in[2], x );
	      break;

	    case 'i':
	      if( bot->connected() )
		{
		  x = atoi( &in[2] );
		  printf("Impulse = %d\n",x );
		  bot->sendImpulse( x );
		}
	      else
		{
			 printf("Info\n");
		  bot->printInfo();
		  bot->printAllPlayers();
		  bot->printRules();
		}
	      break;

	    case 'F':
	      for( i=2; i < 1024; i++ )
		if( in[i] == ' ' )
		  {
		    in[i] = 0;
		    break;
		  }
	      printf("test flag '%s' : ", &in[ 2 ] );
	      printf("%d\n", bot->get( &in[2] ));
	      break;
	
	    case 'l':
	      bot->printLevel();
	      break;

	    case 't':
	      printf("Target : mbfire : ");
	      bot->mbf_printTarget();
	      printf(" : mbnav : ");
	      bot->mbn_printTarget();
	      printf("\n");
	      break;

	    case 'q':
	      if( bot->connected() )
		{
		  printf("disconnecting...\n");
		  bot->disconnect();
		}
	      else
		{
		  printf("Quit\n");
//		  delete bot;
		  exit( 0 );
		}
	      break;

	    case 'v':
	      printf("all Visible entities\n");
	      bot->printVisibleEntities();
	      break;
	      
	    case 'p':
	      if( bot->connected() )
		{
		  printf("Players\n");
		  bot->rankings();
		}
	      break;

	    case 'M':
	      bot->changePort( 25999 );
	      printf("port at 25999\n");
	      break;

	    case 'm':
	      bot->changePort( 26000 );
	      printf("port at 26000\n");
	      break;

	    case 'c':
	      if( !bot->connected() )
		{
		  r = bot->connect();
		  if( !r )
		    printf("Connection accepted\n");
		  else	  
		    printf( r );
		}
	      else
		{
		  printf("Console : %s\n", &in[2] );
		  bot->sendConsole( &in[2] );
		}
	      break;

	    case 'e':
	      printf("Entities\n");
	      bot->printPlayerEntities();
	      break;

	    case 's':
	      if( bot->connected() )
		{
		  sprintf(out, "say %s", &in[2] );
		  printf( out );
		  bot->sendConsole( out );
		}
	      else
		{
		  printf("Server : `%s'\n", &in[2] );
		  bot->server( &in[2] );
		}
	      break;
	      
	    case 'D':
	      printf("destroying client %d\n", atoi(&in[2]) );
#if QPROXY
	      bot->proxyDestroyClient( atoi(&in[2]) );
#endif
	    case 'k':
	      printf("kicking client %d\n", atoi(&in[2]) );
#if QPROXY
	      bot->proxyKickClient( atoi(&in[2]) );
#endif
	      break;

	    case 'X':
#if QPROXY
	      printf("connected proxy's: %d\n", bot->proxyConnected() );
	      bot->proxyDump();
#else
	      printf("QPROXY not #define'd\n");
#endif
	      break;
	      
	    case '?':
	      if( bot->connected() )
		displayConnectedHelp();
	      else
		displayUnconnectedHelp();
	      break;

	    case 'n':
	      bot->name( &in[2] );
	      break;

	    case 'P':
	      bot->pants( atoi(&in[2]) );
	      break;

	    case 'S':
	      bot->shirt( atoi(&in[2]) );
	      break;

#if QPROXY
	    case 'x':
	      printf("sayProxy `%s'\n", &in[2] );
	      bot->sayProxy( &in[2] );
	      break;
#endif

	    case 'd':
	      printf("dump path\n");
	      bot->dumpPath();
	      break;

	    default:
	      printf("unknown command '%c' - try `?' for help\n", in[0] );
	      break;
	    }
	}

      if( bot->getFD() != -1 )
	if( FD_ISSET( bot->getFD(), &a ) )
	  bot->update();
#if QPROXY
      if( !cf->noProxy )
	bot->updateProxy();
#endif
    }

  bot->disconnect();

  delete bot;
  return 0;

}

