/*

**  bspFile class

**  (c) 1997 mike warren

**

**  this code is *not* freeware; please see the file ``README'' or 

**  contact mbwarren@acs.ucalgary.ca

**

**  reads .BSP files into bspFile objects

**

*/







#ifndef _BSPFILE_H_

#define _BSPFILE_H_



#include "defines.h"

#include "entities.h"

#include "planes.h"

#include "vertices.h"

#include "nodes.h"

#include "faces.h"

#include "clipnode.h"

#include "leaves.h"

#include "facelist.h"

#include "edgelist.h"

#include "edges.h"

#include "faces.h"

#include "models.h"

#include "bsphead.h"





class bspFile

{

  bspFile(){}			// no NULL ctor


public:				// TODO : maybe make private, but the get*()

				// functions will return pointers anyway...


  bspHead * head;

  bspEntities * entities;

  bspPlanes * planes;

  bspVertices * vertices;

  bspNodes * nodes;

  bspFaces * faces;

  bspClipnodes * clipnodes;

  bspLeaves * leaves;

  bspFaceList * facelist;

  bspEdges * edges;

  bspEdgeList * edgelist;

  bspModels * models;



  bspFile( char * );		// open file, load, close file

  bspFile( mFile * );		// construct with already open file

  ~bspFile(){}



  void printInfo();		// prints number of each item loaded

  void dump();			// dumps info of all items

    
 int facesShareEdge( int, int );


};





#endif



  

  

  

  

  

