/*
**  simple VECTOR class
**
**  (c) 1997, mike warren
**  mikeBot
**
**
*/


#include "vector.h"
#include <math.h>		// for sqrt()
#include <stdio.h>

//
//  scale : makes the vector x units in length
//
//  TODO : make me better?
//

void vector::scale( int a )
{
  normalize();
  (*this) *= a;
}

//
//  makeFromPY : initializes the vector from the pitch, yaw passed
//

void vector::setFromPY( float pitch, float yaw )
{
	
  float cosPitch = cos( pitch );
  
  x = cos( yaw ) * cosPitch;
  y = sin( yaw ) * cosPitch;
  z = sin( pitch );
}


//
// print() to stdout
//

void vector::print()
{
  printf("(%f, %f, %f)", x, y, z);
}

//
//  operator + () : add two vectors
//

vector vector::operator + (vector & rhs)
{
  vector r;

  r.x = x+rhs.x;
  r.y = y+rhs.y;
  r.z = z+rhs.z;

  return r;
}

//
//  operator - () : substract *this from rhs
//

vector vector::operator - (vector & rhs)
{
  vector r;

  r.x = x - rhs.x;
  r.y = y - rhs.y;
  r.z = z - rhs.z;

  return r;
}

//
//  operator - () : negate vector
//

/*
vector vector::operator - ( )
{
  return vector( -x, -y, -z );
}
*/

//
//  operator * () : dot product
//

float vector::operator * (const vector & rhs)
{
  float r=0;

  r += x * rhs.x;
  r += y * rhs.y;
  r += z * rhs.z;

  return r;
}


//
//  X() : return cross product of *this and rhs
//

vector vector::X( vector & rhs )
{
  vector r;

  r.x = (y * rhs.z) - (z * rhs.y);
  r.y = -((x * rhs.z) - (z * rhs.x));
  r.z = (x * rhs.y) - (y * rhs.x);

  return r;
}


//
// normalize() : normalized the current vector. no return value.
//

void vector::normalize()
{
  float length = this->length();

  x = x / length;
  y = y / length;
  z = z / length;
}

void vector::operator /= ( float n )
{
  if( n==0.0)
    return;
  x /= n;
  y /= n;
  z /= n;
}

void vector::operator += ( vector & v )
{
  x += v.x;
  y += v.y;
  z += v.z;
}

void vector::operator -= ( vector & v )
{
  x -= v.x;
  y -= v.y;
  z -= v.z;
}
  


//
// length() : duh
//

float vector::length()
{
  float length;
  length = x*x + y*y + z*z;
  length = sqrt(length);
  return length;
}

float vector::length2()
{
  return x*x+y*y+z*z;
}

//
//  getYaw : returns yaw represented by vector. thanks to the terminator 
//	     code :)
//

float vector::getYaw()
{

  float yaw;
  int flipv=TRUE;
  int fliph=TRUE;
  float X=x,Y=y;

  if(Y<0) Y=-Y; else flipv=FALSE;
  if(X<0) X=-X; else fliph=FALSE;

  if(X<Y)        yaw = _PI2 - atan(X/Y);
  else if(X>0.0) yaw = atan(Y/X);
  else           yaw = 0;
  if(fliph==TRUE) yaw = _PI - yaw;
  if(flipv==TRUE) yaw = -yaw;
  yaw = fmod(yaw, 2*_PI);
  yaw = (180/_PI)*yaw;

	yaw += 180.0;
	yaw = fmod( yaw, 360.0 );

  return yaw;

}

//
//  getPitch : returns the pitch represented by the vector. terminator again
//

float vector::getPitch()
{ 
  float tilt;
  int flipv=TRUE;
  float X=sqrt(x*x+y*y);
  float Z=z;

  if(Z<0) Z=-Z; else flipv=FALSE;
  if(X<0) X=-X;
  if(X<Z)        tilt = _PI2 - atan(X/Z);
  else if(X>0.0) tilt = atan(Z/X);
  else           tilt = 0;
  if(flipv==TRUE) tilt = -tilt;

  return (180/_PI) * tilt;

}

