/*
**  qsocket interface : does all socket communications : mike warren, 1997
**
**  thanks muchly for the fairly good (UDP needs a bit o' work in documentation
**  but good examples) socket-FAQ, available at:
**
**		http://www.auroraonline.com/sock-faq
**
**  also to Uwe Girlich for his excellent ``Unofficial DEM Format Description''
**  which is somewhere near:
**
**		http://www.physik.uni-leipzig.de/~girlich/
**
**  and to the vary-mostly-correct and well-hacked ``Unoffcial Quake Network
**  Protocol Specs 1.01b'' by a.oliver, which, last i checked, were at:
**
**		http://www.upd.edu.ph/~oliber/quake/
**
**  also thanks to ***********, author of the TERMINATOR bot, for his help
**  and all the people who visited my page and thus encouraged me. :)
**
**  and, to anyone (and everyone, for completeness) who answered my questions
**  in rec.games.computer.quake.editing
**
**
*/


#ifndef _QSOCKET_H_
#define _QSOCKET_H_

#include "defines.h"

#if UNIX

#if AIX
#include <sys/select.h>
#include <strings.h>
#endif

#include <fcntl.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <errno.h>
#include <unistd.h>
#include <netinet/in.h>
#include <limits.h>
#include <netdb.h>
#include <arpa/inet.h>

#else				// no unix
#error "Only support UNIX, presently..."
#endif

#if UNIX && !AIX
#ifdef __GNUC__
extern "C"
{
  int select( int, fd_set *, fd_set *, fd_set *, struct timeval * );
  void bzero( char *, int );
  int socket( int, int, int );
  int connect( int, struct sockaddr *, int );
  int bind( int, struct sockaddr *, int );
  int listen( int, int );
  int sendto( int, char *, int, int, struct sockaddr *, int );
  int recvfrom( int, char *, int, int, struct sockaddr *, int * );
  int gettimeofday( struct timeval *, struct timezone * );
}
#endif
#endif
  



class qsocket
{
	struct sockaddr_in remote;		// address of client and server
	struct sockaddr_in local;		// client is me, server is them

	int fd;

	struct in_addr * atoaddr( char * address );
	
   public:
	
	qsocket( char * addr=QCS_DEFAULT_SERVER, int port=QCS_DEFAULT_PORT );
	qsocket( int port );	// "listen" socket
	~qsocket();

	int send( char *, int );
	int receive( char *, int );

	struct in_addr lastPacketIP() { return remote.sin_addr; }
	
	void changePort( int p ) {remote.sin_port = htons( p );local.sin_port = htons( p );}
	int getLocalPort() { return ntohs( local.sin_port ); }
	int getRemotePort() { return ntohs( remote.sin_port ); }
	
	int getFD() { return fd; }

};


#endif
