/*
**
**  QSOCKET implementation and support routines; encapsulates socket IO
**
**  (c) mike warren, 1997
**  mikeBot
**
*/

#include "defines.h"
#include "qsocket.h"

#include <sys/types.h>
#include <sys/socket.h>

/*
**  convert string to an actual address, "0.0.0.0" and "www.crap.com" forms
**  accepted. straight out of sockets faq ( www.auroraonline.com/sock-faq )
**
** !NOTE: ONLY the address returned from THE LAST CALL IS VALID
*/

struct in_addr * qsocket::atoaddr( char * address )
{
	struct hostent * host;
	static struct in_addr saddr;

			// no address at all...

	if( !address || !*address )
	  return NULL;

			// check for "1.2.3.4" etc.

	saddr.s_addr = inet_addr( address );
	if( saddr.s_addr != (unsigned long)-1 )
	{
#if (DEBUG & DQS)
	  printf("qsocket::atoaddr(): using `%s' directly\n", address); 
#endif
	  return &saddr;
	}

			// no, so try "www.foo.com"

	printf("qsocket::atoaddr(): DNS lookup on `%s'\n", address);

	host = gethostbyname( address );
	if( host != NULL )
	{
#if (DEBUG & DQS)
	  printf("qsocket::atoaddr(): lookup on `%s' succeeded\n", address);
#endif
	  char * b = host->h_addr_list[0];
	  printf("qsocket::atoaddr(): DNS answer `%u.%u.%u.%u'\n",b[0],b[1],b[2],b[3] );
	  return (struct in_addr *) *host->h_addr_list;
	}

	fprintf(stderr, "qsocket::atoaddr(): DNS lookup failed\n");

	return NULL;

}

/*
**  ctor : checks addresses (if passed) and sets ports, etc. on local and
**         server, and connects and binds local port.
**
*/


qsocket::qsocket( char * addr, int port )
{

	struct in_addr * temp;

	memset( (char *)&remote, 0, sizeof(remote) );
	memset( (char *)&local, 0, sizeof(local) );

	if ( (temp = atoaddr( addr )) == NULL )
	  {
#if QTHROW
	    throw( "qsocket::qsocket(): invalid address" );
#else
	    fprintf(stderr, "qsocket::qsocket() : invalid address `%s'\n", addr);
	    exit( -1 );
#endif
	  }

	remote.sin_port = htons( port );
	remote.sin_family = AF_INET;
	remote.sin_addr.s_addr = temp->s_addr;

	local.sin_family = AF_INET;
	local.sin_addr.s_addr = htonl( INADDR_ANY );
	local.sin_port = htons( 0 );

	if ( (fd = socket( AF_INET, SOCK_DGRAM, 0 )) < 0 )
	{
#if QTHROW
	  throw( "qsocket::qsocket(): could not obtain socket\n" );
#else
	  perror( "qsocket::qsocket(): socket()" );
	  exit( -1 );
#endif
	}
#if (DEBUG & DQS)
	else
	  printf("qsocket::qsocket(): fd = %d\n", fd );
#endif

	if ((bind( fd, (struct sockaddr *)&local, sizeof(local)) ) < 0)
	{
#if QTHROW
	  throw( "qsocket::qsocket(): bind failed\n" );
#else
	  perror( "qsocket::qsocket(): bind()" );
	  exit( -1 );
#endif
	}
#if (DEBUG & DQS)
	else
	  printf("qsocket::qsocket(): bind succeded\n");
#endif


#if AIX
	if( (fcntl( fd, F_SETFL, O_NONBLOCK )) < 0 )
#else
	if( (fcntl( fd, F_SETFL, O_NDELAY )) < 0 )
#endif
	   {
#if QTHROW
	     throw("qsocket::qsocket(): fcntl");
#else
	     perror("qsocket::qsocket(): fcntl");
	     exit( -1 );
#endif
	   }

}

/*
**  binds to local address ONLY
**
*/

qsocket::qsocket( int port )
{

	memset( (char *)&remote, 0, sizeof(remote) );
	memset( (char *)&local, 0, sizeof(local) );

	remote.sin_port = htons( port );
	remote.sin_family = AF_INET;
	remote.sin_addr.s_addr = htonl( INADDR_ANY );

	local.sin_family = AF_INET;
	local.sin_addr.s_addr = htonl( INADDR_ANY );
	local.sin_port = htons( port );

	if ( (fd = socket( AF_INET, SOCK_DGRAM, 0 )) < 0 )
	{
#if QTHROW
	  throw( "qsocket::qsocket(): could not obtain socket\n" );
#else
	  perror( "qsocket::qsocket(): socket()" );
	  exit( -1 );
#endif
	}
#if (DEBUG & DQS)
	else
	  printf("qsocket::qsocket(): fd = %d\n", fd );
#endif

	if ((bind( fd, (struct sockaddr *)&local, sizeof(local)) ) < 0)
	{
#if QTHROW
	  throw( "qsocket::qsocket(): bind failed\n" );
#else
	  perror( "qsocket::qsocket(): bind()" );
	  exit( -1 );
#endif
	}
#if (DEBUG & DQS)
	else
	  printf("qsocket::qsocket(): bind succeded\n");
#endif


#if AIX
	if( (fcntl( fd, F_SETFL, O_NONBLOCK )) < 0 )
#else
	if( (fcntl( fd, F_SETFL, O_NDELAY )) < 0 )
#endif
	   {
#if QTHROW
	     throw("qsocket::qsocket(): fcntl");
#else
	     perror("qsocket::qsocket(): fcntl");
	     exit( -1 );
#endif
	   }

}



/*
**  dtor : disconnects (just a close, but hey)
*/

qsocket::~qsocket()
{
	close( fd );
	fd = 0;
#if (DEBUG & DQS)
	printf("qsocket::~qsocket(): socket closed\n");
#endif
}

/*
**
**  send() : sends the (entire) buffer passed in to the current remote
**	     bytes sent is returned, or <= 0 on error
**
*/

int qsocket::send( char * b, int s )
{
  return sendto(fd, b, s, 0, (struct sockaddr *)&remote, sizeof(remote));
}

	  
/*
**
**  receive() : returns bytes read into buffer (or -1 on error)
**
*/

int qsocket::receive( char * buff, int max )
{
  int r;
#if !AIX
  int s = sizeof(remote);
  r = recvfrom( fd, buff, max, 0, (struct sockaddr *)&remote, &s);
#else
  size_t s = sizeof(remote);
  r = recvfrom( fd, buff, max, 0, (struct sockaddr *)&remote, &s);
#endif
  return r;
}
