/*
**
**  QENTITY class
**
**  (c) 1997, mike warren
**  mikeBot
**
**  keeps track of where, what different entities are.
**
*/

#ifndef _QENTITY_H_
#define _QENTITY_H_

#include "defines.h"
#include "vector.h"

//
//  TODO : convert the index into a type through the modeltable[] entry
//

class qentity
{
public:

  int index;			// into modeltable[]
  int default_index;
  int frame;			// model's frame (usefull for determing
				// weather player is dead)
  int skin;			// good for determining armour type
  
  vector origin;		// center of entity
  vector facing;		// which way is it looking?
  vector velocity;		// how fast, which direction moving?

  float lastTime;		// last timestamp update received

  int rate;


  qentity() { index=0;frame=0;skin=0;origin.set(0,0,0);facing.set(0,0,0);lastTime=0.0; rate=0; }
	  
  void updateOrigin( vector & v, float t1, float t2 ) { velocity = v - origin; origin = v; velocity /= (t2 - t1); }

};


#endif
