/*
**
**  QCS handles client-server communication
**
**  (c) mike warren, 1997
**  mikeBot
**
**  ``send'' functions; sendDisconnect() <--- use qcs::disconnect() instead!!
**  sendMovement(), etc. not for human consumption
**
*/


#include "defines.h"
#include "qcs.h"
#include "vector.h"
#include <stdlib.h>
#include <math.h>


/*
**  send : sends an arbitrary packet; correctly waits for acks on reliable 
**
*/

int qcs::send( qpacket & qp )
{
#if QCS_SAFESEND
  if( !connected() )
    return 0;
#endif

  if( qp.getType() != qpacket::reliableEnd && 
     qp.getType() != qpacket::reliableFragment )
    {
      return qp.send( sock );
    }
  else
    {
	return ackQueue.addPacket( qp, sock );
    }
}

/*
**  sendKeepalive : sends a no op (unreliable) aka client to server keepalive
**
*/

int qcs::sendKeepalive()
{
#if QCS_SAFESEND
  if( !connected() )
    return 0;
#endif
	
  outPacket.reset();
  outPacket.addBEint( outgoingUnreliable++ );
  outPacket.addByte( CS_KEEPALIVE );
  outPacket.changeType( qpacket::unreliable );
  return send( outPacket );
}

/*
**  sendDisconnect : send a disconnect packet (unreliable)
**
*/

int qcs::sendDisconnect()
{

  if( !connected() )
    return 0;

  outPacket.reset();
  outPacket.addBEint( outgoingUnreliable++ );
  outPacket.addByte( CS_DISCONNECT );
  outPacket.changeType( qpacket::unreliable );
	
  return send ( outPacket );
}

/*
**  sendMovement : sends the current movement values 
**
*/

int qcs::sendMovement()
{

#if QCS_SAFESEND
  if( !connected() )
    return 0;
#endif

  float ts=0.0;

  if( newTimestamp < oldTimestamp )
    {
      printf("%f, %f\n", newTimestamp, oldTimestamp);
      ts = oldTimestamp;
    }
  else
    {
      ts = newTimestamp;
    }
	      
  outPacket.reset();
  outPacket.addBEint( outgoingUnreliable++ );
  outPacket.addByte( CS_ACTION );
  outPacket.addLEfloat( ts );
  outPacket.addAngle( 0 );
  outPacket.addAngle( 0 );
  outPacket.addByte( (char)0 );
  outPacket.addLEshort( (short)350 );
  outPacket.addLEshort( (short)0);
  outPacket.addLEshort( (short)0 );
  outPacket.addByte( 0 );
  outPacket.addByte( 0 );

  outPacket.changeType( qpacket::unreliable );

  if( outPacket.getNumber() > outgoingUnreliable )
    printf("*******************************\n");

  return send( outPacket );
}

/*
**  sendConsole : sends a console command. MAKE SURE THERE IS A NEWLINE AT THE
**  END!! (i think...;) )
**
*/

int qcs::sendConsole( char * st )
{
#if QCS_SAFESEND
  if( !connected() )
    {
      printf("qcs::sendConsole(): not connected\n");
      return 0;
    }
#endif

  outPacket.reset();
  outPacket.addBEint( outgoingReliable++ );
  outPacket.addByte( CS_CONSOLE );
  outPacket.addString( st );
  outPacket.changeType( qpacket::reliableEnd );
	
  return send ( outPacket );
}


