/*
**
**  QCS handles client-server communications
**
**  (c) mike warren, 1997
**  mikeBot
**
**  ``print'' functions; not terribly usefull, but fun nonetheless
**
*/

#include "defines.h"
#include "csdefs.h"
#include "qcs.h"

/*
**  printPlayerInfo : gets info on specified player and prints it
**
*/

void qcs::printPlayerInfo( int z )
{

  if( connected() )
    {
      fprintf(stderr, "qcs::printPlayerInfo(): can't; connected\n");
      return;
    }

  outPacket.reset();
  outPacket.addByte( CCREQ_PLAYER_INFO );
  outPacket.addByte( (char) z );
  outPacket.changeType( qpacket::control );
  send( outPacket );

  if( !waitForPacket() )
    {
      fprintf(stderr, "qcs::printInfo(): no responce\n");
      return;
    }
}

	
/*
 **  printInfo : gets current server info and prints it out
 **
 */

void qcs::printInfo()
{

  if( connected() )
    {
      fprintf(stderr, "qcs::printPlayerInfo(): can't; connected\n");
      return;
    }


  outPacket.reset();
  outPacket.addByte( CCREQ_SERVER_INFO );
  outPacket.addString( "QUAKE" );
  outPacket.addByte( (char)0x03 ); // changeme to QS_NET_PROTOCOL
  outPacket.changeType( qpacket::control );
  send( outPacket );

  if( !waitForPacket() )
    {
      fprintf(stderr, "qcs::printInfo(): no responce\n");
      return;
    }

  printf("server name : %s\n", info.name );
  printf("address     : %s\n", info.address );
  printf("level       : %s\n", info.level );
  printf("players     : %d\n", info.players );
  printf("max players : %d\n", info.maxPlayers );

}


	










