/*
**
**  QCS class 
**
**  (c) 1997, mike warren
**  mikeBot
**
**  handles client-server communications.
**  the only functions you *need* are qcs::connect() and qcs::server()
**  and qcs::update() every time data is available at the socket (qcs::getFD())
**
**  (note that the constructor *will*not* connect() to the server but that the
**  dtor *will* disconnect )
**
*/

#ifndef _QCS_H_
#define _QCS_H_

#include "defines.h"
#include "qpacket.h"
#include "qsocket.h"
#include "qstruct.h"		// serverinfo
#include "qentity.h"
#include "qplayer.h"
#include "qack.h"		// acknowledge queue
#include "vector.h"
#include "options.h"


#include "csdefs.h"
#include "scdefs.h"


#include <stdio.h>

class qcs
{

private:
  qsocket  * sock;	// `new' binds and looks up address
  qcs( qcs & ){}		// can't call copy constructor
#if QPROXY
  qproxy * proxy;			// so "real" client can connect
#endif

  char currentServerIP[ Q_MAX_STRING ]; // set with 'server()'

protected:

  FILE * demoFP;	// if recording demo, this is non-null

  char servers[ 10 ][ Q_MAX_STRING ];
  char address[ 10 ][ Q_MAX_STRING ];

  char qcs_message[ Q_MAX_STRING ]; // will be written to .DEMos on each packet

  vector facing;		// actual facing; could be from mbnav or mbfire
				// used to write demo packet

  vector fireParticle, navParticle;
  

		// only allocate a coupla packets; less `new' calls.
		// the *fragments buffer is for prespawn; reliableFragments
		// and relibaleEnds are accumulated here, then decoded

  qpacket inPacket;		// incoming packets
  qpacket outPacket;		// outgoing packet
  qpacket * fragments;		// reliableFragments
  qpacket prespawns1;		// for recording demos half-way through
  qpacket prespawns2;		// for recording demos half-way through
  qpacket prespawns3;		// for recording demos half-way through

  int outgoingUnreliable;	// packet counts; important, since
  int outgoingReliable;		// packets are accepted or rejected
  int incomingReliable;		// based on these numbers...
  int incomingUnreliable;	// (??? reset on level change ???)

  int haveConnection;		// 1 if server has accepted connect

  qack ackQueue;		// handles reliable client-server packets


  serverInfo info;		// decodeControl,decodeMessages() fills tis
  char * result;		// result from last connect attempt

  float newTimestamp;		// current timestamp of server
  float oldTimestamp;		// old timestamp
  int signonLevel;		// are we playing yet? only if this is 3
  int myEntityNumber;		// into entity array

			// TODO : change these to ints representing model/sound
			//        types; easy to check for ears, firecontrol
  
  char * modeltable[ QCS_MAX_MODELS ];
  char * soundtable[ QCS_MAX_SOUNDS ];
  int modeltypes[ QCS_MAX_MODELS ]; 
  int soundtypes[ QCS_MAX_SOUNDS ];

  qentity entities[ QCS_MAX_ENTITIES ];	// these only structs; keep track of
  qplayer players[ QCS_MAX_PLAYERS ];	// entities/players (frags, etc.)

  int decodeControl( qpacket & );
  int decodeReliable( qpacket & );
  int decodeUnreliable( qpacket & );
  int decodeAcknowledge( qpacket & );
  int decodeQPacket( qpacket & );
  int decodeMessages( qpacket & );

  int send( qpacket & );	// handles acks for reliables packet, too

  void initTables();		// makes modeltable[], soundtable[] = 0
  void deleteTables();		// deletes and non-NULL entries
  void updateTableTypes();

	
public:

  qcs();
  virtual ~qcs() { disconnect(); delete sock; deleteTables(); }

  void reinit();		// deletes everything, reconstructs

  int sendKeepalive();		// also NO-OP
  int sendDisconnect();		// unreliable; makes server happier
  virtual int sendMovement();	// impulses, jump, facing, etc.
  int sendConsole( char * );	// console command, like "say hi"

  int getSignonLevel() { return signonLevel; }

  int update();			// call ONLY IF the socket has data( SELECT() )
#if QPROXY
  int updateProxy() { if(proxy) proxy->update(); }
#endif
  int getFD() { if(sock) return sock->getFD(); else return -1; }
#if QPROXY
  int getProxyFD() { if(proxy) return proxy->getFD(); else return -1; }
#endif
  char * connect();		// returns message if connection declined,
				// returns (char *)0 if connected successfully
  void disconnect();		// sends disconnect packet to server, too
  int recordDemo( char *);	// pass filename
  int stopDemo();		// stops demo and writes disconnect packet
  int waitForPacket();		// up to QCS_MAX_WAIT seconds (CONTROL ONLY)

		// if connected, disconnects but DOES NOT CONNECT to the new
		// server (just binds the socket and looks up the IP, if
		// nessecary (i.e. ``quake.foobar.ca'' needs to be looked up)

  int server( char * ip, int port = 26000 );

			// these functions all return TRUE/FALSE and are
			// fairly self-explanatory...

  int connected() { return (haveConnection) ? TRUE : FALSE; }
  int recording() { return (demoFP) ? TRUE : FALSE; }
  
			// some helpful(ish) output functions

  void printInfo();		// prints (after getting) server info
  void printPlayerInfo( int );	// gets player info, prints it
  void printLevel() {printf("level is '%s' (%s)\n",info.level,modeltable[1]);}

				// proxy stuff
#if QPROXY
  int isProxyConnected() { return proxy->connected(); }
  void waitForProxy() { while( !proxy->connected() ) proxy->update(); }
#endif

			// any BOT class should override these;
			// (i.e. override them, ya dummy! ;) )
			// they are called when the event they name
			// happens...fairly self-explanatory

  virtual void changedLevel( char * x ){ printf("QCS:level `%s'\n", x ); }
  virtual void consoleCommand( char * x ) { printf("QCS:console `%s'\n",x); }
  void rankings();
  virtual void entityUpdated( int x ){ printf("QCS:entity %d\n", x ); }
  virtual void entityChanged( int x ) { printf("QCS:new entity %s\n", modeltable[entities[x].index] ); }
  virtual void timestampChanged( float x ){ printf("QCS:time %f\n",x); }
  virtual void playerstateUpdate( int i,int v ) { printf("QCS:%d is %d\n",i,v);}
  virtual void gotSayMessage( char * x ) { printf("QCS:%s\n", x ); }
  virtual void receivedDamage( int amt, vector & v ) { printf("QCS:damage : %d from ",amt);v.print(); printf("\n"); }
  virtual void centerPrint( char * x ) { printf("QCS:cprint `%s'\n", x); }

  virtual void updateHealth( int x ) { printf("QCS:health %d\n",x); }
  virtual void updateArmour( int x ) { printf("QCS:armour %d\n",x); }
  virtual void updateCells( int x ) { printf("QCS:cells %d\n", x); }
  virtual void updateShells( int x ) { printf("QCS:shells %d\n",x ); }
  virtual void updateRockets( int x ) { printf("QCS:rockets %d\n", x); }
  virtual void updateNails( int x ) { printf("QCS:nail %d\n", x); }
  virtual void updateWeapon( int x ) { printf("QCS:weapon %d\n", x); }
  virtual void updateItems( int x ) { printf("QCS:items %d\n", x); }


};

#endif
