/*
**  QACK class
**
**  (c) 1997, mike warren
**  mikeBot
**
**  handles resending of reliable client-server packets. Call QACK::resend()
**  every second or so...#defined as QACK_TIMEOUT
**
**
*/

#include "defines.h"
#include "qack.h"


/*
**  ctor
**
*/

qack::qack()
{
  head=0;
  tail=0;
  size= 0;

				// this is just safety; they should already be
				// qpacket::unknown

  for( int i=0; i < QACK_MAX; i++ )
      packets[i].changeType( qpacket::unknown );

}

/*
**  addPacket : first sends the packet (if queue empty), then adds it to the 
**		queue of ack waits. FALSE returned if queue full...
**
*/

int qack::addPacket( qpacket & qp, qsocket * sock )
{

  if( size >= QACK_MAX )
    return FALSE;

  if( size == 0 )
    {
      current=0;
      qp.send( sock );		// only send if the queue is empty
#if DEBUG & DQACK
      printf("qack::addPacket(): send packet #%d\n", qp.getNumber() );
#endif
    }

  size++;

  packets[ head ].copy( qp );
  packetNumbers[ head ] = qp.getNumber();

  if( ++head >= QACK_MAX )
    head=0;

#if DEBUG & DQACK
  printf("qack::addPacket(): size is now %d\n", size );
  dumpPacketNumbers();
#endif
  
  return TRUE;
}


/*
**  gotAck : erases the appropriate packet (if applicable) and sends the next
**           one (if there is one)
**
*/

int qack::gotAck( int x, qsocket * sock )
{

#if DEBUG & DQACK
  printf("qack::gotAck(): got %d\n", x );
#endif

  if( size == 0 )
    return FALSE;

  if( packetNumbers[ tail ] == x )
    {
      deletePacket();		// takes off tail
      resend( sock );		// sends next packet (if available)
      return TRUE;
    }
  else
#if DEBUG & DQACK
    printf("qack::gotAck(): expected %d, not %d\n", packetNumbers[tail], x );
#else
  ;
#endif

#if DEBUG & DQACK
  dumpPacketNumbers();
#endif

  return FALSE;

}
/*
**  resend : call me whenever. will return FALSE if not enough time elapsed
**	     since the last call, however.
**
*/

int qack::resend( qsocket * sock )
{
  if( size == 0 )
    return FALSE;

  current++;

#if DEBUG & DQACK
  printf("qack::resend(): time is %d\n", current);
#endif

  if( (current) < QACK_MAX_TIMEOUT )
    return FALSE;

  current=0;

  packets[ tail ].send( sock );

#if DEBUG & DQACK
      printf("qack::resend(): sent packet #%d\n", packetNumbers[tail]);
#endif

  return TRUE;


}

      
/*
**  deletePacket : removes ``tail'' packet from the queue
**
*/

int qack::deletePacket( )
{

  if( size == 0 )
    return FALSE;

  packets[ tail ].changeType( qpacket::unknown );
#if DEBUG & DQACK
  packets[ tail ].changeNumber( -1 );
  printf("qack::deletePacket(): delete #%d\n", packetNumbers[tail]);
#endif


  size--;
  if ( ++tail >= QACK_MAX )
    tail = 0;

#if DEBUG & DQACK
  printf("qack::deletePacket(): size now %d\n", size );
#endif

  return TRUE;
}


/*
**  dumpPacketNumbers : (debuging) prints out the packet numbers of every
**			packet in the queue
**
*/

#if DEBUG & DQACK

void qack::dumpPacketNumbers()
{

  int i;

  printf("qack::dumpPacketNumbers(): ");

  for( i=0; i < QACK_MAX; i++ )
    printf("%d ", packets[ i ].getNumber() );

  printf("\n");
}

#endif



  
      
  

  
