
/*
**
**  miscelasneous functions 
**
**  (c) 1997 mike warren
**  mikeBot
**
**
**
*/

#include "defines.h"
#include <ctype.h>
#include <stdio.h>
#include "qstruct.h"

/*
**  parseName : removes newlines and maps special characters to
**		"real" (i.e. ASCII < 128) ones for stoopid names.
**
**  TODO : character mapping :)
*/

void parseName ( unsigned char * n )
{

  int i=0;

  while( n[ i ] )
    {
      n[i] = n[i] % 128;
      if( n[i] < 32 && n[i] > 0)
	n[i] = '_';
      i++;
    }

}

/*
**  printDefines : prints out which preprocessor #define's were active when
**		   compiling
**
*/

void printDefines()
{
#if UNIX
  printf("UNIX, ");
#endif
#if AIX
  printf("AIX, ");
#endif
#if WIN32
  printf("WIN32 (Windows 95), ");
#endif
#ifdef MIKEBOT
  printf("MIKEBOT, ");
#endif
#ifdef QBIG_ENDIAN
  printf("BIG-ENDIAN, ");
#endif
#ifdef QLITTLE_ENDIAN
  printf("LITTLE-ENDIAN, ");
#endif
#if QTHROW
  printf("QTHROW, ");
#endif
#if QPROXY
  printf("QPROXY, ");
#endif

  printf("\n");
  printf("QCS_MAX_TIMEOUTS = %d\n", QCS_MAX_TIMEOUTS);
  printf("QCS_MAX_WAIT = %d seconds\n", QCS_MAX_WAIT);

#if DEBUG
  printf("DEBUG : ");
#if DEBUG & DQP
  printf("qpacket ");
#endif
#if DEBUG & DQS
  printf("qsocket ");
#endif
#if DEBUG & DQCS
  printf("qcs ");
#endif
#if DEBUG & DQACK
  printf("qacknowledge ");
#endif
#if DEBUG & DMBF
  printf("mbfire ");
#endif
#if DEBUG & DMBN
  printf("mbnav ");
#endif
#if DEBUG & DMB
  printf("mbot ");
#endif
#if DEBUG & DQX
  printf("qproxy ");
#endif
  printf("\n");
#endif				// DEBUG

}
			
