/*
**
**  MBOT class
**
**  (c) 1997 mike warren
**  mikeBot
**
**
**  handles some bot functions; most are in MBFIRE and MBNAV (well, its
**  derived from them afterall)
**
*/


#include "defines.h"
#include "mbot.h"
#include <math.h>

/*
**  ctor
**
*/

mbot::mbot()
{
  respawn=0;
}

/*
**  update : calls mbfire update, then mbnav update(), then messes with the
**	     idealSpeeds from mbnav and the facing from mbfire, and sends
**	     a movement packet. (first calls qcs::update() )
**
*/

void mbot::update()
{

  map.updatePosition( entities[myEntityNumber].origin );

  sprintf(qcs_message, "%s\n", mbotbase_localMessage );


  mbotbase::update();


  if( isDead( myEntityNumber ) && !respawn )
    {
      printf( "I'm dead; respawning...\n" );
      respawn = 30;
    }

  float theta, alpha;

				// facing = firecontrol facing
				// mbn_facing = actual place to go

  vector mbn_facing;		// should be determined by your nav class

	theta = facing.getYaw();
	alpha = mbn_facing.getYaw();
	
	alpha = theta-alpha;

	alpha *= (_PI/180.0);

  float mbn_velocity = 0.0;	// should be target velocity (<= 320.0)

	forwardSpeed = (int)( ( cos(alpha) )*mbn_velocity );
	strafeSpeed = (int)( ( sin(alpha) )*mbn_velocity );
	verticleSpeed=0;

	sendMovement();
}


/*
**  sendMovement : overrides QCS::sendMovement
**
*/

int mbot::sendMovement()
{
  float ts=0.0;
  char actions=0;

				// TODO : actions |= 0x01 to shoot, 0x02 jump

  if( respawn ) { respawn--; if( respawn==15 ) actions = 0x03; else actions=0;}
      
  if( newTimestamp < oldTimestamp )
    {
      printf("mbot::sendMovement(): timestamp warning : %f, %f\n", newTimestamp, oldTimestamp);
      ts = oldTimestamp;
    }
  else
    {
      ts = newTimestamp;
    }

  outPacket.reset();				// start again
  outPacket.addBEint( outgoingUnreliable++ );	// unreliable packet
  outPacket.addByte( CS_ACTION );		// 0x03
  outPacket.addLEfloat( ts );			// timestamp
  outPacket.addAngle( facing.getPitch() );	// mbfire
  outPacket.addAngle( facing.getYaw() );	// mbfire
  outPacket.addAngle( 0.0 );			// <-- why need roll?
  outPacket.addLEshort( (short)forwardSpeed );	// mbnav, changed
  outPacket.addLEshort( (short)strafeSpeed);	// mbnav, changed
  outPacket.addLEshort( (short)verticleSpeed );	// mbnav, changed
  outPacket.addByte( actions );			// mbnav, mbfire
  outPacket.addByte( 0 );			// mbfire (impulse)
  outPacket.changeType( qpacket::unreliable );	// calls qpacket::update() too

#if DEBUG & DQCS
  if( outPacket.getNumber() > outgoingUnreliable )
    printf("*******************************\n");
#endif

  return send( outPacket );
}


/*
**  setOptsFromFile : initilization of user options
**
*/

int mbot::setOptsFromFile( char * fname )
{
  FILE * fp;
  char s[ 1024 ];
  char * a, *b;
  int val, i=0;
  int mode=0;

  if ( !(fp = fopen( fname, "r" )) )
    {
      perror("mbot::setOptsFromFile()");
      return FALSE;
    }

  while( fgets( s, 1024, fp ) )
    {
      val=0;
      while( s[val] )
	{
	  if( s[val] == '\n' )
	    s[val] = 0;
	  val++;
	}

      switch( s[0] )
	{
	case '\n':
	case '\0':
	case '#':		// comment character
	  break;

	case '*':		// special label character; check rest
	  if( !strncmp( "flags", &s[1], 5 ) )
	    mode = 1;
	  else if ( !strncmp( "servers", &s[1], 7 ) )
	    mode = 2;
	  else
	    fprintf(stderr, "mbot::setOptsFromFile(): `%s' unknown\n", &s[1] );
	  break;

	default:
	  if( mode == 0 )
	    fprintf(stderr, "mbot::setOptsFromFile(): line ignored\n");
	  else if (mode == 1)
	    {
	      a = strtok( s, " \t" );
	      b = strtok( NULL, " \t" );
	      val = atoi( b );
	      opts.set( a, val );
	      printf("mbot::setOptsFromFile(): %s = %d\n", a, val );
	    }
	  else if (mode == 2)
	    {
	      a = strtok( s, " \t");
	      b = strtok( NULL, " \t");
	      strcpy( servers[i], a );
	      strcpy( address[i], b );
	      i++;
	      printf("mbot::setOptsFromFile(): `%s' at IP `%s'\n", a,b );
	    }
	  break;
	}

    }

  fclose( fp );
  return TRUE;
}

  
