/*
**
**  example of how to use classes
**
**  (c) 1997 mike warren
**  mikeBot
**
*/

#include "mbot.h"
#include "cmdflags.h"
#include <ctype.h>

#if QTHROW && __GNUC__
void terminate()
{
	printf("terminated : unhandled exception\n");
}
#endif

int main( int argc, char *argv[] )
{

  fd_set a;			// for select()
  char in[ 1024 ];		// buffer for user input
  char * r;			// for result from qcs::connect()
  int i;

  cmdFlags * cf = new cmdFlags( argc, argv );

  mbot bot;

  printDefines();		// prints out preprocessor #defines

  if( cf->address && !cf->port )
    bot.server( cf->address, 26000 );
  else if ( cf->address && cf->port )
    bot.server( cf->address, cf->port );
  else if ( !cf->address )
    bot.server( "129.128.109.135", 26000 );

  if( cf->filename )
    if ( !bot.recordDemo( cf->filename ) )
     perror( cf->filename );
    else
      ;
  else
    printf("Not recording demo\n");

  int running=1;
  struct timeval tv;
  tv.tv_sec = 2;
  tv.tv_usec = 2000;

  if( (r=bot.connect()) )
    {
      printf("connection refused : %s", r);
      exit( -1 );
    }
  else
    printf("conection established\n");

  while( running )
    {

				// wait for input from user or on the
				// QCS object's file descriptor (socket)

      FD_ZERO( &a );
      FD_SET( 0, &a );
      FD_SET( bot.getFD(), &a );
      if ( (select( 100, &a, 0, 0, &tv )) < 0 )
	perror("select");

				// got input from file desctiptor 0, stdin
				// notice the excellent user-friendlyness ;)

      if( FD_ISSET( 0, &a ) )
	{
	  memset( in, 0, 1024 );
	  read( 0, in, 1024 );
	  for( i=0; in[ i ] != '\n'; i++ )
	    ;
	  in[ i ] = 0;

	  switch( in[0] )
	    {
	    case 'q':
	      printf("Quit\n");
	      running=0;
	      break;

	    default:
	      printf("unknown command; sending as console\n");
	      bot.sendConsole( in );
	      break;
	    }
	}
      else if ( FD_ISSET( bot.getFD(), &a ) )
	bot.update();

    }

  bot.disconnect();
  exit(0);

}
