/*
**  support class for bspFile
**  (c) 1997 mike warren
**
**  this code is *not* freeware. See the file ``README'' or contact
**  mbwarren@acs.ucalgary.ca
**
**  (excuse the rather long ::read() inlined functions, but i didn't feel like
**   having lotsa .cc files :) )
**
*/




#ifndef _LEAVES_H_
#define _LEAVES_H_

#include "defines.h"
#include "vector.h"
#include "mfile.h"

class bspLeaf
{
public:
  enum type_t { normal, solid, water, slime, lava, sky, unknown };

private:
  type_t type;
  int visilist;
  vector bboxMin;		// uses shorts, not floats, in file...
  vector bboxMax;
  unsigned short faceListId;
  unsigned short faceListNum;
  
  int sounds;			// 4 chars; i don't use 'em

  bspLeaf(){}

public:
  
  bspLeaf( mFile & mf ) { read( mf ); }
  
  void read( mFile & mf ) { switch( mf.readLEint() ) { case -1: type=normal; break; case -2: type=solid; break; case -3: type=water; break; case -4: type=slime; break; case -5: type=lava; break; case -6: type=sky; break; default: type=unknown;break; }; visilist=mf.readLEint(); bboxMin.setx( (float)mf.readLEshort() ); bboxMin.sety( (float)mf.readLEshort() ); bboxMin.setz( (float)mf.readLEshort() ); bboxMax.setx( (float)mf.readLEshort() ); bboxMax.sety( (float)mf.readLEshort() ); bboxMax.setz( (float)mf.readLEshort() ); faceListId=mf.readLEushort(); faceListNum=mf.readLEushort(); sounds=mf.readLEint(); }

  type_t getType() { return type; }
  int getVisilist() { return visilist; }
  vector getBboxMin() { return bboxMin; }
  vector getBboxMax() { return bboxMax; }
  int getFaceListId() { return (int)faceListId; }
  int getFaceListNum() { return (int)faceListNum; }

  void dump() { printf("%d %u %u\n", type, faceListId, faceListNum ); }

};


class bspLeaves
{
  bspLeaf ** leaves;
  int loadedLeaves;

  bspLeaves(){}

public:
  
  bspLeaves( mFile & mf, int n ) { leaves = new bspLeaf* [ n ]; for(int i=0; i < n; i++) leaves[i]=0; loadedLeaves=0; read( mf, n ); }
  ~bspLeaves() { for( int i=0; i < loadedLeaves; i++ ) delete leaves[i]; delete leaves; }

  void read( mFile & mf, int n ) { for( int i=0; i < n; i++ ) leaves[i] = new bspLeaf( mf ); loadedLeaves=n; }

  bspLeaf * getLeaf( int x ) { if ( x>= 0 && x < loadedLeaves ) return leaves[x]; else return 0; }
  int getNum() { return loadedLeaves; }

  void dump() { for(int i=0; i < loadedLeaves; i++) leaves[i]->dump(); }

};


#endif


