/*
**  graph class
**
**  builds a directed graph of the current level as the bot moves through
**  the level. as position is updates, this class figures out where the bot
**  is and if that new node has a floor polygon or is lava/slime/water, it
**  is added to the graph.  use the public: interface functions to get info
**  about the level (like lineOfSight())
**
*/


#ifndef _GRAPH_H_
#define _GRAPH_H_

#include "defines.h"
#include "bspfile.h"
#include "vector.h"
#include "stack.h"


struct table
{
  char known;
  int dist;
  int p;
  table() { known=0; dist=-1; p=0; }
};

class queue
{
  int * entries;
  int start;
  int end;
  int num;
  int max;

public:
  queue( int size=1024 ) { entries=new int[ size ]; start=0; end=0; num=0; max=size; }
  ~queue() { delete[] entries; }

  void add( int x ) { if( num >= max ) return; entries[start]=x; start = ++start % max; num++; }
  int get() { if (num==0) return -1; end %= max; num--; return entries[ end++ ]; }

  int isEmpty() { return num==0; }

};

struct adjNode
{
  adjNode * next;
  int data;

  adjNode( int x ) { data=x; next=0; }
  adjNode( int x, adjNode * n ) { data=x; next=n; }
};





class bspGraph
{

private:

  bspFile * map;

  vector position;
  int currentNode;
  int oldNode;

  int listSize;
  adjNode ** adjList;		// vector of pointers to linked lists
  table * t;			// for shortest path

  void updateTable( int );
  int findLeaf( vector );
  void eraseGraph();
  
public:

  bspGraph() { currentNode=oldNode=0;map=0;listSize=0; adjList=0; t=0; }
  ~bspGraph() { delete map; eraseGraph(); }

  void updatePosition( vector );
  int getCurrentLeafType();
  int getCurrentLeaf() { return currentNode; }

  int isShotBlocked( vector, vector * h=0 );
  int isLineBlocked( vector start, vector end, vector * hp=0 );
  int getLeafType( vector );
  int getLeaf( vector x ) { return findLeaf( x ); }
  int isLoaded() { return (map!=0); }

  stack< int > * findPath( int, int );
  int addLink( int, int );
  int removeLink( int, int );
  int isLink( int, int );

  vector getLeafOrigin( int );

  int leavesAdjacent( int, int );

  int lineHitsLava( vector, vector);
  const bspFile * getMap() { return map; }

  int newMap( char * fname );

};

#endif
  

