
/*
**  directed graph class
**
**  uses adjacency list method
**
**
*/


#ifndef _DGRAPH_H_
#define _DGRAPH_H_

#include "defines.h"
#include "graph.h"
#include "bspfile.h"
#include "stack.h"


struct table
{
  char known;
  int dist;
  int p;
  table() { known=0; dist=-1; p=0; }
};

class queue
{
  int * entries;
  int start;
  int end;
  int num;
  int max;

public:
  queue( int size=1024 ) { entries=new int[ size ]; start=0; end=0; num=0; max=size; }
  ~queue() { delete[] entries; }

  void add( int x ) { if( num >= max ) return; entries[start]=x; start = ++start % max; num++; }
  int get() { if (num==0) return -1; end %= max; num--; return entries[ end++ ]; }

  int isEmpty() { return num==0; }

};

struct adjNode
{
  adjNode * next;
  int data;

  adjNode( int x ) { data=x; next=0; }
  adjNode( int x, adjNode * n ) { data=x; next=n; }
};

class dgraph
{

  int leaves;
  adjNode ** adjList;		// vector of pointers to linked lists
  table * t;			// for shortest path

  void updateTable( int );

  dgraph(){}

public:

  dgraph( bspGraph * );
  dgraph( int size );
  ~dgraph() { for( int i=0; i < leaves; i++ ) delete adjList[i]; delete[] adjList; delete[] t; }

  void addLink( int, int );
  void dump();
  
  stack< int > * findPath( int, int );
};

#endif
