/*
**
**
*/


#include "defines.h"
#include "dgraph.h"

/*
**  dump : prints dgraph
**
*/

void dgraph::dump()
{
  int i;
  adjNode * p;
  
  for( i=0; i < leaves; i++ )
    {
      p = adjList[ i ];
      while( p->next )
	{
	  printf("%d --> %d\n", i, p->next->data );
	  p = p->next;
	}
    }
}

/*
**  ctor from BSP : LEVEL MUST NOT BE NULL!!!
**
**  change me
**
*/

dgraph::dgraph( bspGraph * level )
{
  const bspFile * map = level->getMap();

  leaves = map->leaves->getNum();

  t = new table[ leaves ];
  adjList = new (adjNode *)[ leaves ];
  int i, j;
  for( i=0; i < leaves; i++ )
    adjList[i] = new adjNode( -1 );

				// now make graph from leaves :)


  for( i=0; i < leaves; i++ )
    {
       for( j=0; j < leaves; j++ )
	 if( i != j )
	   {
	     if( level->leavesAdjacent( i, j ) )
	       addLink( i,j );
	   }
     }

  
}
  


/*
**  ctor
**
*/

dgraph::dgraph( int size )
{ 
  t = new table[ size ];
  adjList = new (adjNode *)[ size ]; 
  leaves=size-1; 
  for( int i=0; i < leaves; i++ )
    adjList[ i ] = new adjNode(-1);
}


/*
**  addLink : links node A to B
**
*/

void dgraph::addLink( int a, int b )
{
  if( a > leaves || b > leaves )
    return;

  adjNode * p = adjList[ a ];
  
  while( p->next )
    p = p->next;

  p->next = new adjNode( b );
}


/*
**  updateTable : does just that
**
*/

void dgraph::updateTable( int a )
{
  static queue q;
  int v, w;
  adjNode * p;

  t[ a ].dist = 0;		// start node
  q.add( a );

  while( !q.isEmpty() )
    {
      v = q.get();
      p = adjList[ v ];
      while( p->next )
	{
	  w = p->next->data;
	  p = p->next;
	  if( t[w].dist == -1 )
	    {
	      t[w].dist = t[v].dist + 1;
	      t[w].p = v;
	      q.add( w );
	    }
	}
    }

}

/*
**  findPath : finds a path from node A to B. returns a pointer to a stack
**             or NULL if no path
**
*/

stack<int> * dgraph::findPath( int a, int b )
{
  int v;

  if( t[a].dist != 0 )
    updateTable( a );


  if( t[b].p == -1 )
    return 0;

  stack<int> * r = new stack<int>;


  v = b;
  r->push( v );
  
  int length=0;
  while( v != a )
    {
      if( length++ > leaves )
	{
	  delete r;
	  return 0;
	}
      v = t[ v ].p;
      r->push( v );
    }

  return r;
      

}
       
