/*
**  simple VECTOR class
**
**  (c) 1997, mike warren
**  mikeBot
**
*/

#ifndef _VECTOR_H_
#define _VECTOR_H_

#include "defines.h"

#define ERROR 0.0001
#define _PI (float)3.1415926535897932846
#define _PI2 (float)1.57079632679489661923

#define FABS(x) (((x) > (float)0.0) ? (x) : (-x))

class vector
{
private:
  float x, y, z;


public:
  vector() {}
  vector( float a, float b, float c ) { x=a; y=b; z=c; }
//  vector( vector& a ) { x=a.x; y=a.y; z=a.z; }
  ~vector() {}

  vector operator + (vector &);	// wheee...add two vectors
  vector operator - (vector &);	// subtract two (duh)
//  vector operator - ();		// unary minus (negate)
  float operator * (vector &);	// dot product, really
  void operator /= ( float ); // divide by a scaler
  void operator *= ( float a ) { x *=a; y *= a; z *= a; }
  void operator += (vector &);
  void operator -= (vector &);
  vector X ( vector &);		// cross product

  void scale( int x );		// make the vector x long

  void normalize();		// normalize vector
  float length();		// get its length

  void set( float a, float b, float c ) { x=a; y=b; z=c; }
  void setx( float a ) { x=a; }
  void sety( float a ) { y=a; }
  void setz( float a ) { z=a; }
  void setFromPY( float, float );

  int operator == (const vector & r) { return (x==r.x && y==r.y && z==r.z); }
  int operator != (vector & r) { return !( *this == r ); }
  int close (const vector & r) { return ( (FABS(x-r.x) < ERROR) && (FABS(y-r.y) < ERROR) && (FABS(z-r.z) && ERROR) ); }
  int xequal (vector & r) { return( x==r.x ); }
  int yequal (vector & r) { return( y==r.y ); }
  int zequal (vector & r) { return( z==r.z ); }
  float getx(){ return x; }
  float gety(){ return y; }
  float getz(){ return z; }

  float getYaw();
  float getPitch();
  float getRoll(){return (float)0.0;}

				// this outputs like (%f, %f, %f)

				// these input/output compatable with vec3_t
				// in quake

  void print();

};

#endif

  
