/*
**  bspFile, packFile classes test
**
**  (c) 1997 mike warren
**  mikeBot
**  
**  loads TEST/TEST.BSP from TEST.PAK, then dumps all the info in TEST.BSP
**
*/


#include "bspfile.h"
#include "mpack.h"
#include "mfile.h"

int main()
{

  packFile * pf;
  mFile * mf;

  try
    {
      pf = new packFile( "test.pak" );
    }
  catch( char * err )
    {
      fprintf(stderr, err );
      exit( -1 );
    }

  pf->dumpDirectory();

  mf = pf->getFile( "test\\test.txt" );
  if( !mf )
    {
      fprintf(stderr, "file not found\n");
      exit( -1 );
    }

  for( int i=0; i < mf->getSize(); i++ )
    putchar( mf->readByte() );

  delete mf;

  mf = pf->getFile( "test\\test.bsp" );
  if( !mf )
    {
      fprintf(stderr, "file not found\n");
      exit( -1 );
    }

  bspFile bf( mf );
  bf.printInfo();
  bf.dump();

  delete mf;


  delete pf;

  return 0;

}

/*
**  this has to be removed for MSVC++ compilation
**
*/

#if !WIN
void terminate()
{
	printf("terminate(): fatal error : unhandled exception\n");
	exit( -1 );
}
#endif















/*

  mFile * mf = 0;

  try 
  {
    mf = new mFile( argv[1] );
  }
    catch( char * x )
  {
     printf( "%s\n", x );
     exit(-1);
  }

  bspHead * bh = new bspHead( *mf );

  printf("version = %d\n", bh->getVersion() );

 	printf("entities\n");

	mf->setReadPos( bh->getEntry(BSPD_ENTITIES).getOffset() );
	bspEntities * be = new bspEntities( *mf, bh->getEntry(BSPD_ENTITIES).getSize() );
	be->dump();

	printf("planes\n");
	
	mf->setReadPos( bh->getEntry(BSPD_PLANES).getOffset() );
	bspPlanes bp( *mf, bh->getEntry(BSPD_PLANES).getSize() / BSP_PLANE_SIZE );
	bp.dump();

	printf("vertices\n");

	mf->setReadPos( bh->getEntry(BSPD_VERTICES).getOffset() );
	bspVertices bv( *mf, bh->getEntry(BSPD_VERTICES).getSize() / BSP_VERTEX_SIZE );
	bv.dump();

	printf("nodes\n");

	mf->setReadPos( bh->getEntry(BSPD_NODES).getOffset() );
	bspNodes bn( *mf, (int)(bh->getEntry(BSPD_NODES).getSize()/BSP_NODE_SIZE) );
	bn.dump();

	printf("faces\n");

	mf->setReadPos( bh->getEntry(BSPD_FACES).getOffset() );
	bspFaces bf( *mf, bh->getEntry(BSPD_FACES).getSize()/BSP_FACE_SIZE );
	bf.dump();

	printf("clipnodes\n");

	mf->setReadPos( bh->getEntry(BSPD_CLIPNODES).getOffset() );
	bspClipnodes bc( *mf, bh->getEntry(BSPD_CLIPNODES).getSize()/BSP_CLIPNODE_SIZE );
	bc.dump();

	printf("leaves\n");

	mf->setReadPos( bh->getEntry(BSPD_LEAVES).getOffset() );
	bspLeaves bl( *mf, bh->getEntry(BSPD_LEAVES).getSize()/BSP_LEAF_SIZE);
	bl.dump();

	printf("facelist\n");
	
	mf->setReadPos( bh->getEntry(BSPD_FACELIST).getOffset() );
	bspFaceList facel( *mf, bh->getEntry(BSPD_FACELIST).getSize()/BSP_FACELIST_SIZE);
	facel.dump();

	printf("edgelist\n");

	mf->setReadPos( bh->getEntry(BSPD_EDGELIST).getOffset() );
	bspEdgeList edgel( *mf, bh->getEntry(BSPD_EDGELIST).getSize()/BSP_EDGELIST_SIZE);
	edgel.dump();

	printf("edges\n");

	mf->setReadPos( bh->getEntry(BSPD_EDGES).getOffset() );
	bspEdges edges( *mf, bh->getEntry(BSPD_EDGES).getSize()/BSP_EDGE_SIZE);
	edges.dump();

	printf("models\n");

	mf->setReadPos( bh->getEntry(BSPD_MODELS).getOffset() );
	bspModels models( *mf, bh->getEntry(BSPD_MODELS).getSize()/BSP_MODEL_SIZE);
	models.dump();



}
*/
