/*
**  support class for bspFile
**  (c) 1997 mike warren
**
**  this code is *not* freeware. See the file ``README'' or contact
**  mbwarren@acs.ucalgary.ca
**
**  (excuse the rather long ::read() inlined functions, but i didn't feel like
**   having lotsa .cc files :) )
**
*/



#ifndef _PLANES_H_
#define _PLANES_H_

#include "defines.h"
#include "mfile.h"
#include "vector.h"

class bspPlane
{
public:
  enum type_t { x,y,z, unknown };

private:
  vector normal;
  float distance;
  type_t type;

  bspPlane(){}

public:

  bspPlane( mFile & mf ) { read( mf ); }

  void read( mFile & mf ) { normal.setx( mf.readLEfloat() ); normal.sety( mf.readLEfloat() ); normal.setz( mf.readLEfloat() ); distance=mf.readLEfloat(); switch( mf.readLEint() ) { case 0:case 3: type = x; break; case 1:case 4: type=y; break; case 2: case 5: type=z; break; default: type=unknown; break; } }

  void dump() { normal.print(); printf(" %f, %d\n", distance, type ); }

};




class bspPlanes
{

  bspPlane ** planes;
  int loadedPlanes;

  bspPlanes(){};

public:

  bspPlanes( mFile & mf, int num ) { planes=new bspPlane* [ num ]; for( int i=0; i < num; i++ ) planes[i] = (bspPlane *)0; loadedPlanes=0; read( mf, num ); }
  ~bspPlanes() { for( int i=0; i < loadedPlanes; i++ ) delete planes[i]; delete planes; }

  void read( mFile & mf, int num ) { for( int i=0; i < num; i++ ) planes[i] = new bspPlane( mf ); loadedPlanes=num; }

  void dump() { for( int i=0; i < loadedPlanes; i++ ) planes[i]->dump(); }

  int getNum() { return loadedPlanes; }
  bspPlane * getPlane( int x ) { if( x < loadedPlanes && x >= 0 ) return planes[x]; else return 0; }

};


#endif

  
  
