/*
**  packFile class : implementation
**  (c) 1997 mike warren
**
**  this code is *not* freeware; please see the file ``README'' or 
**  contact mbwarren@acs.ucalgary.ca
**
**  opens and returns mFile objects from a .PAK file
**
*/



#include "mpack.h"
#include <string.h>


/*
**  ctor : loads directory, etc. 
**
*/

packFile::packFile( char * pakname )
{
  mFile * mf;

  try 
    {
      mf = new mFile( pakname );
    } 
  catch( char * err ) 
    {
      printf( err );
      throw err;
    }

  mf->setReadPos( 0 );
  ph = new packHeader( *mf );

  mf->setReadPos( ph->getOffset() );

  numDirEntries = ph->getSize()/58;

  entries = new packEntry*[ numDirEntries ];
  
  for( int i=0; i < numDirEntries; i++ )
    entries[i] = new packEntry( *mf );

#if !WIN	
 fd = dup( mf->getFd() );
#else
  fd = _dup( mf->getFd() );
#endif

  delete mf;

  if( fd < 0 )
    {
#if QTHROW
      throw( "packFile::packFile(): couldn't duplicate file descriptor\n" );
#else
      perror("packFile::packFile(): fcntl()");
      exit(-1);
#endif
    }

}
  

/*
**  getFile : returns a (new) mFile object pointing to a section of .PAK
**            or NULL if not found. (wildcards NOT allowed)
**
*/

mFile * packFile::getFile( char * name )
{
  int i;
  int found=0;

  for( i=0; i < numDirEntries; i++ )
    if( !strncmp( entries[i]->getFilename(), name, 50 ) )
      {
	found=1;
	break;
      }
  
  if( !found )
    return (mFile *)0;

  int fd1 = dup( fd );

  if( fd1 < 0 )
    {
      perror("packFile::getFile(): fcntl()");
      return (mFile *)0;
    }

  mFile * r = new mFile( fd1, entries[i]->getOffset(), entries[i]->getOffset()+entries[i]->getSize() );

  return r;
}


/*
**  dumpDirectoty : prints all files in pack
**
*/

void packFile::dumpDirectory()
{
  for( int i=0; i < numDirEntries; i++ )
    printf("%-50s : %6d %6d\n", 
	   entries[i]->getFilename(), 
	   entries[i]->getOffset(), 
	   entries[i]->getSize() );
}
      
    


